<?php
namespace local;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Sector extends \engine\Game{
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
    }
    public function setType(){
        $this->showJsonBuilds();
        $this->view->setType("json");
        $this->view->echoEver(); 
    }
    private function showJsonBuilds(){
        $this->map = new \model\Map($this);
        $this->selectXY();
        $this->selectSector();
    }
    private function setData(){
        $this->rank = new \model\Rank($this);
        $rankIcon = $this->rank->getRank($this->sql["user_rating"]);
        if($this->sql["type"] == "city")
            $this->view->addData("sector", ["id"=>$this->sql["id"], "x"=>$this->sql["x"], "y"=>$this->sql["y"], "nick"=>$this->sql["nick"], "rating"=>$this->sql["rating"], "type"=>$this->sql["type"], "rankIcon" => $rankIcon]);
        else
            $this->view->addData("sector", ["id"=>$this->sql["id"], "x"=>$this->sql["x"], "y"=>$this->sql["y"], "nick"=>$this->sql["nick"], "level"=>$this->sql["level"], "type"=>$this->sql["type"]]);
    }
    private function selectSector(){
        $this->sql = $this->map->selectXY($this->x, $this->y);
        if($this->sql==null)
            $this->setUndefined();
        else
            $this->setData();
    }
    private function setUndefined(){
        $this->view->addData("error", ["x"=>$this->x, "y"=>$this->y]);
    }
    private function setXYPOST(){
        if($_POST["x"]<0 or $_POST["x"]>1000000 or $_POST["y"]<0 or $_POST["y"]>1000000)
            $this->setUndefined();
    }
    private function selectXY(){
        if(isset($_POST["x"]) and isset($_POST["y"])){
            $this->setXYPOST();
            $this->x = intval($_POST["x"]);
            $this->y = intval($_POST["y"]);
        }
        else
            $this->setUndefined();
    }
}