<?php
namespace menu;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Left extends \engine\Game{
    private $html = '';
    private $top = 'Локации';
	public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\Menu($this);
        $this->modelRank = new \model\Rank($this);
        $this->modelUser = new \model\User($this);
    }
    private function getCabinet(){
        $this->cabinet .=$this->model->getButton('/html/page/profil.php', '/img/rank/1.png', 'Профиль', '{&quot;userId&quot;: '.$this->user->getParam("id").'}');
        $this->cabinet .=$this->model->getButton('/html/page/rank.php', '/img/icons/rank.png', 'Боевой пропуск');
        $this->cabinet .=$this->model->getButton('/html/page/market.php', '/img/icons/market.png', 'Магазин');
     //   $this->cabinet .=$this->model->getButton('/html/page/exchange.php', '/img/icons/exchange.png', 'Обменник');
        $this->cabinet .=$this->model->getButton('/html/page/box.php', '/img/icons/box.png', 'Сокровище');
        $this->cabinet .=$this->model->getButton('/html/page/present.php', '/img/icons/present.png', 'Подарки');
        $this->cabinet = '
        

        
        <div id="cabinet">
            <div class="p-5-10">
                '.$this->cabinet.'
            </div>
        </div>';
    }
    private function getUnion(){
        if($this->user->getParam("alliance")>0){
            $this->union .=$this->model->getButton('/html/page/union.php', '/img/icons/union.png', 'Мой союз', '{&quot;unionId&quot;: '.$this->user->getParam("alliance").'}');
            $this->union .=$this->model->getButton('/html/page/union.php?news', '/img/icons/news.png', 'Новости', '{&quot;unionId&quot;: '.$this->user->getParam("alliance").'}');
            $this->union .=$this->model->getButton('/html/page/union.php?chat', '/img/icons/chat.png', 'Чат', '{&quot;unionId&quot;: '.$this->user->getParam("alliance").'}');
            $this->union .=$this->model->getButton('/html/page/union.php?raid', '/img/icons/attack.png', 'Рейды', '{&quot;unionId&quot;: '.$this->user->getParam("alliance").'}');
        }
        else
            $this->union .= '<div class="center fz20">Вы не состоите в союзе</div>';
        $this->union = '
        <div id="union">
            <div class="p-5-10">
                '.$this->union.'
            </div>
        </div>';
    }
    private function getMail(){
        $this->mail .=$this->model->getButton('/html/page/mail.php?new', '/img/icons/newSms.png', 'Новое');
        $this->mail .=$this->model->getButton('/html/page/mail.php', '/img/icons/sms.png', 'Входящие');
        $this->mail .=$this->model->getButton('/html/page/mail.php?outgoing', '/img/icons/outgoingMail.png', 'Исходящие');
        $this->mail .=$this->model->getButton('/html/page/notice.php', '/img/icons/notice.png', 'Уведомления');
        $this->mail .=$this->model->getButton('/html/page/chat.php', '/img/icons/chat.png', 'Чат');
        $this->mail = '
        <div id="mail">
            <div class="p-5-10">
                '.$this->mail.'
            </div>
        </div>';
    }
    private function getHelp(){
        $this->help .=$this->model->getButton('/html/page/news.php', '/img/icons/news.png', 'Новости');
        $this->help .=$this->model->getButton('/html/page/support.php', '/img/icons/support.png', 'Служба поддержки');
        $this->help .=$this->model->getButton('/html/page/help.php', '/img/icons/help.png', 'Справка');
        $this->help .=$this->model->getButton('/html/page/contacts.php', '/img/icons/contacts.png', 'Контакты');
        $this->help = '
        <div id="help">
            <div class="p-5-10">
                '.$this->help.'
            </div>
        </div>';
    }
    private function getRating(){
        $this->rating .=$this->model->getButton('/html/page/rating.php?rank', '/img/icons/rating.png', 'Рейтинг');
        $this->rating .=$this->model->getButton('/html/page/rating.php?union', '/img/icons/union.png', 'Союзы');
        $this->rating .=$this->model->getButton('/html/page/rating.php?provinces', '/img/icons/provinces.png', 'Провинции');
        $this->rating .=$this->model->getButton('/html/page/rating.php?online', '/img/icons/online.png', 'Онлайн');
        $this->rating = '
        <div id="rating">
            <div class="p-5-10">
                '.$this->rating.'
            </div>
        </div>';
    }
    private function start(){
        $this->getCabinet();
        $this->getUnion();
        $this->getMail();
        $this->getHelp();
        $this->getRating();
        $this->html = '
        

        
        <div id="content" class="h100">
    	    <div class="h20">
            </div>
            <div class="h55">
                <div id="panel" class="panel overAuto h100">
                    <div class="rel">
                    	<div id="exit" class="exitMenu" onclick="window.brouser.exit()"> 
                    		<img src="'.$this->url.'/img/menu/exit.png" height="40px">
                    	</div>
                    </div>
            	    <div id="page">
            	        '.$this->cabinet.'
            	        '.$this->union.'
            	        '.$this->mail.'
            	        '.$this->help.'
            	        '.$this->rating.'
            	   </div>
            	</div>
            </div>
            <div class="h20">
            </div>
            <div id="foot">
                <div class="foot">
                    <div class="rel">
            	        <div class="inherit">
            	            <div class="podloshkaMenuBottom"></div>
            	        </div>
            	    </div>
                </div>
            	<div class="foot">
                    <div class="rel">
                        <div class="bottom">
                            <div class="w100 MenuColor center">
                                <div id="cabinetMenu" onclick=setMenu("cabinet") style="float: left;" class="w20 filter05">
                                    <img src="'.$this->url.'/img/menu/icons/1.png"  width="70%">
                                    <br>
                                    Кабинет
                                </div>
                                <div id="unionMenu" onclick=setMenu("union") style="float: left;" class="w20 filter05">
                                    <img src="'.$this->url.'/img/menu/icons/2.png"  width="70%">
                                    <br>
                                    Союз
                                </div>
                                <div id="mailMenu" onclick=setMenu("mail") style="float: left;" class="w20 filter05">
                                    <img src="'.$this->url.'/img/menu/icons/3.png"  width="70%" >
                                    <br>
                                    Почта
                                </div>
                                <div id="helpMenu" onclick=setMenu("help") style="float: left;" class="w20 filter05">
                                    <img src="'.$this->url.'/img/menu/icons/4.png"  width="70%">
                                    <br>
                                    Помощь
                                </div>
                                <div id="ratingMenu" onclick=setMenu("rating") style="float: left;" class="w20 filter05">
                                    <img src="'.$this->url.'/img/menu/icons/5.png"  width="70%">
                                    <br>
                                    Рейтинг
                                </div>
                            </div>
                        </div>
                    </div>
            	</div>    
            </div>
    	</div>
    	
    	<script>
    	    var menuList = {
    	        "name": undefined,
    	        "cabinet": function(){
    	            return "";
    	        },
    	        "union": function(){
    	            return "Союз";
    	        },
    	        "mail": function(){
    	            return "Почта";
    	        },
    	        "help": function(){
    	            return "Помощь";
    	        },
    	        "rating": function(){
    	            return "Рейтинг";
    	        }
    	    };
    	    function setMenu(name){
    	        if(menuList.name!=undefined){
    	            $("#"+menuList.name+"Menu").removeClass("selectIconMenu");
    	            $("#"+menuList.name+"Menu").addClass("filter05");
    	            $("#"+menuList.name).hide();
    	        }
    	        menuList.name = name;
    	        $("#"+menuList.name+"Menu").addClass("selectIconMenu");
    	        $("#"+menuList.name+"Menu").removeClass("filter05");
    	        $("#"+menuList.name).show();
    	    }
    	    $("#cabinet").hide();
    	    $("#union").hide();
    	    $("#mail").hide();
    	    $("#help").hide();
    	    $("#rating").hide();
    	    setMenu("cabinet");
    	    $("#content").on("click", function(){
                $("#content #panel, #foot, #exit").toggle();
                window.brouser.exit();
            });
            $("#content #panel, #foot, #exit").on("click", function(event){
                event.stopPropagation();
            });
    	</script>';
    }
    public function setView(){
        $this->start();
        echo $this->html;
    }
}