<?php
namespace model;
class Mail{
    private $dialog = 0;
    public function __construct(&$game){
        $this->game = $game;
    }
    public function readMsg($id){
        $query = "UPDATE `mail` SET `read` = 1 WHERE `id` = {?}";
		$this->game->db->query($query,[$id]);
    }
    public function getMsgDialog($dialog){
        $query = "
        SELECT mail.*, user_nick.nick as nick, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
		FROM `mail`  
		left JOIN (SELECT id, nick FROM `users`  GROUP BY  `id` ) user_nick
		ON `mail`.user  = user_nick.id
		left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `mail`.user  = `user_map`.user
		
		left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
            left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `mail`.user  = `invader_user`.invader 
       	left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        WHERE `mail`.id = {?}";
		return $this->game->db->query($query,[$dialog])->fetch_assoc();
    }
    public function getMsgDialogOutgoing($dialog){
        $query = "
        SELECT mail.*, user_nick.nick as nick, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
		FROM `mail`  
		left JOIN (SELECT id, nick FROM `users`  GROUP BY  `id` ) user_nick
		ON `mail`.user2  = user_nick.id
		left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `mail`.user2  = `user_map`.user
		
		left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
            left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `mail`.user2  = `invader_user`.invader 
       	left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        WHERE `mail`.id = {?}";
		return $this->game->db->query($query,[$dialog])->fetch_assoc();
    }
    public function getCountDialogsById($dialog){
        $query = "
        SELECT count(*) col
		FROM `mail_msg`  
		WHERE `dialog` = {?}";
		return $this->game->db->query($query,[$dialog])->fetch_assoc()["col"];
    }
    public function checkInStockDialog($dialog, $user){
        $query = "
        SELECT count(*) col
		FROM `mail`  
		WHERE `id` = {?} and `user2` = {?}";
		return $this->game->db->query($query,[$dialog, $user])->fetch_assoc()["col"];
    }
    public function checkInStockDialogOutgoing($dialog, $user){
        $query = "
        SELECT count(*) col
		FROM `mail`  
		WHERE `id` = {?} and `user` = {?}";
		return $this->game->db->query($query,[$dialog, $user])->fetch_assoc()["col"];
    }
    public function countDialog($user){
        $query = "
        SELECT count(*) col
		FROM `mail`  
        WHERE `user2` = {?}";
		return $this->game->db->query($query,[$user])->fetch_assoc()["col"];
    }
    public function countDialogOutgoing($user){
        $query = "
        SELECT count(*) col
		FROM `mail`  
        WHERE `user` = {?}";
		return $this->game->db->query($query,[$user])->fetch_assoc()["col"];
    }
    public function getPageDialog($user, $start){
        $query = "
        SELECT mail.*, user_nick.nick as nick, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
		FROM `mail`
		left JOIN (SELECT id, nick FROM `users`  GROUP BY  `id` ) user_nick
		ON `mail`.user  = user_nick.id
		left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `mail`.user  = `user_map`.user
		
		left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
            left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `mail`.user  = `invader_user`.invader 
       	left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        WHERE `mail`.user2 = {?}
        ORDER BY `mail`.id DESC LIMIT $start, 10";
		return $this->game->db->query($query,[$user]);
    }
    public function getPageDialogOutgoing($user, $start){
        $query = "
        SELECT mail.*, user_nick.nick as nick, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
		FROM `mail`
		left JOIN (SELECT id, nick FROM `users`  GROUP BY  `id` ) user_nick
		ON `mail`.user2  = user_nick.id
		left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `mail`.user2  = `user_map`.user
		
		left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
            left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `mail`.user2  = `invader_user`.invader 
       	left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        WHERE `mail`.user = {?}
        ORDER BY `mail`.id DESC LIMIT $start, 10";
		return $this->game->db->query($query,[$user]);
    }
    private function addMsgSql($user, $msg){
        $query = "INSERT INTO `mail_msg` SET   `user` = {?}, `dialog` = {?}, `msg` = {?}, `time` = {?}";
    	$this->game->db->query($query,[$user, $this->dialog, $msg, time()]);
    }
    public function addMsg($user, $user2, $msg){
        $query = "INSERT INTO `mail` SET   `user` = {?}, `user2` = {?}, `msg` = {?}, `time` = {?}";
    	$this->game->db->query($query,[$user, $user2, $msg, time()]);
        //$this->searchDialog($user, $user2);
        //$this->addMsgSql($user, $msg);
    }
    private function searchDialogSql($user, $user2){
        $query = "SELECT count(*) col, dialog
        FROM mail_user 
        WHERE (`user` = {?} or `user` = {?})
        GROUP BY dialog
        HAVING COUNT(*) > 1";
		$dialog =  $this->game->db->query($query, [$user, $user2])->fetch_assoc();
        $this->dialog  = $dialog["dialog"];
        $this->dialogCol = $dialog["col"];
    }
    private function searchDialog($user, $user2){
        $this->searchDialogSql($user, $user2);
        if($this->dialogCol<2){
            $this->createDialog();
            $this->dialog = $this->game->db->getConn()->insert_id;    
            $this->addInDialogUser($user);
            $this->addInDialogUser($user2);
        }
    }
    private function createDialog(){//Создаём диалог
        $query = "INSERT INTO `mail_dialog` SET   `time` = {?}";
    	$this->game->db->query($query,[time()]);
    }
    private function addInDialogUser($user){//Добавляем узера в диалог
        $query = "INSERT INTO `mail_user` SET   `user` = {?}, `dialog` = {?}, `time` = {?}";
    	$this->game->db->query($query,[$user, $this->dialog, time()]);
    }
    public function numberOfUnread($user){
        $query = "
        SELECT count(*) col
		FROM `mail` WHERE `user2` = {?} and `read`=0";
		return $this->game->db->query($query,[$user])->fetch_assoc()["col"];
    }
}