<?php
namespace model;
class Market{
    public function __construct(&$game){
        $this->game = $game;
    }
    
    // Методы для активации купола
    public function activateCupol($city_id, $duration_hours) {
        
      //  $query = "UPDATE `map` SET `cupol_end_time` = {?} WHERE `id` = {?}";
      //  $this->game->db->query($query, [$end_time, $city_id]);
      
      ////
        // 02.09.2025
        $d = $this->game->db->query("SELECT * FROM `users` WHERE `id` = {?} LIMIT 1", [$city_id])->fetch_assoc();
     
        if ($d['dome'] > time())
        $end_time = $d['dome'] + ($duration_hours * 3600);
        else
        $end_time = time() + ($duration_hours * 3600);
        
        $query = "UPDATE `users` SET `dome` = {?} WHERE `id` = {?}";
        $this->game->db->query($query, [$end_time, $city_id]);
      
    }
    
    // Методы для активации строителя
    public function activateBuilder($user_id, $duration_hours) {
        //$end_time = time() + ($duration_hours * 3600);

        ////
        // 05.09.2025
        $d = $this->game->db->query("SELECT * FROM `users` WHERE `id` = {?} LIMIT 1", [$user_id])->fetch_assoc();
     
        if ($d['builder_end_time'] > time())
        $end_time = $d['builder_end_time'] + ($duration_hours * 3600);
        else
        $end_time = time() + ($duration_hours * 3600);
        
        //
        
        $query = "UPDATE `users` SET `builder_end_time` = {?} WHERE `id` = {?}";
        $this->game->db->query($query, [$end_time, $user_id]);
    }
    
    // Кнопка для покупки купола
    public function getButtonCupol($key, $name, $duration_name, $price, $discount) {
        return '
            <div onclick=buyCupol('.$key.') class="p-3-0">
                <div class="w100 m1 bottonMini7p">
                    <div class="btn-link">
                        <div class="fl p6">
                            <img src="'.$this->game->url.'/img/icons/cupol.png" class="vs" height="30">
                        </div>
                        <div class="fl">
                            <b>'.$duration_name.'</b>
                        </div>
                        <div class="fr p1-6">
                            '.($price != $discount ? '<span class="discount tdlt">'.$price.'</span>' : '').'
                            <img src="'.$this->game->url.'/img/icons/cristal.png" class="vs" height="20px">'.$discount.'
                        </div>
                    </div>
                </div>
            </div>';
    }
    
    // Кнопка для покупки строителя
    public function getButtonBuilder($key, $name, $duration_name, $price, $discount) {
        return '
            <div onclick=buyBuilder('.$key.') class="p-3-0">
                <div class="w100 m1 bottonMini7p">
                    <div class="btn-link">
                        <div class="fl p6">
                            <img src="'.$this->game->url.'/img/icons/builder.png" class="vs" height="30">
                        </div>
                        <div class="fl">
                            <b>'.$duration_name.'</b>
                        </div>
                        <div class="fr p1-6">
                            '.($price != $discount ? '<span class="discount tdlt">'.$price.'</span>' : '').'
                            <img src="'.$this->game->url.'/img/icons/cristal.png" class="vs" height="20px">'.$discount.'
                        </div>
                    </div>
                </div>
            </div>';
    }
    
    // Остальные существующие методы...
    public function error($name, $text, $buttonText){
        return '
        <div id="error" class="h100 w100"> 
            <div class="center50pros maxWidth400px w100 center">
                <div class="p10">
                    <div class="errorName w100 mAuto p10-0 fz30 ">
                        '.$name.'
                    </div>
                    <div class="p10-0 errorYellow boderRBottom5px">
                        <div class="p-5-10 errorText fz20">
                            '.$text.'
                        </div>
                        <div class="p-3-0">
                            <div class="buttonError w70 mAuto" onclick="$(&quot;#error&quot;).remove()">
                                Хорошо
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>';
    }
    
    public function goodBuy($name, $text, $buttonText){
        return '
        <div id="error" class="h100 w100"> 
            <div class="center50pros maxWidth400px w100 center">
                <div class="p10">
                    <div class="goodMess w100 mAuto p10-0 fz30 ">
                        '.$name.'
                    </div>
                    <div class="p10-0 errorYellow boderRBottom5px">
                        <div class="p-5-10 errorText fz20">
                            '.$text.'
                        </div>
                        <div class="p-3-0">
                            <div class="bottonMiniBlue w70 mAuto" onclick="$(&quot;#error&quot;).remove()">
                                Хорошо
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>';
    }
    
    public function plassCristal($user, $plass){
        $query = "UPDATE `users` SET `cristal` = `cristal` + {?} WHERE `id` = {?}";
        $this->game->db->query($query,[$plass, $user]);
    }
    
    public function minusGold($user, $minus){
        $query = "UPDATE `users` SET `gold` = `gold` - {?} WHERE `id` = {?}";
        $this->game->db->query($query,[$minus, $user]);
    }
    
    public function plassGold($user, $plass){
        $query = "UPDATE `users` SET `gold` = `gold` + {?} WHERE `id` = {?}";
        $this->game->db->query($query,[$plass, $user]);
    }
    
    public function minusCristal($user, $minus){
        $query = "UPDATE `users` SET `cristal` = `cristal` - {?} WHERE `id` = {?}";
        $this->game->db->query($query,[$minus, $user]);
    }
    
    public function plassClef($user, $plass){
        $query = "UPDATE `users` SET `clef` = `clef` + {?} WHERE `id` = {?}";
        $this->game->db->query($query,[$plass, $user]);
    }
    
    public function minusClef($user, $minus){
        $query = "UPDATE `users` SET `clef` = `clef` - {?} WHERE `id` = {?}";
        $this->game->db->query($query,[$minus, $user]);
    }
    
    public function plassScroll($city, $plass){
        $query = "UPDATE `map` SET `scroll` = `scroll` + {?} WHERE `id` = {?}";
        $this->game->db->query($query,[$plass, $city]);
    }
    
    public function getButton($url, $icon, $name){
        return '
            <div onclick=window.brouser.go("'.$this->game->url.'/html/page/market.php?'.$url.'") class="p-3-0">
                <div class="w100 m1 bottonMini7p">
                    <div class="btn-link">
                        <div class="fl p6">
                            <img src="'.$this->game->url.'/img/icons/'.$icon.'.png" class="vs" height="30">
                        </div>
                        <div class="fl"><b>'.$name.'</b></div>
                    </div>
                </div>
            </div>';
    }
    
    public function getButtonCristal($key,  $price){
        return '
            <div onclick=buyCristal('.$key.') class="p-3-0">
                <div class="w100 m1 bottonMini7p">
                    <div class="btn-link">
                        <div class="fl p6">
                            <img src="'.$this->game->url.'/img/icons/cristal.png" class="vs" height="30">
                        </div>
                        <div class="fl">
                            <b>'.$key.'</b>
                        </div>
                        <div class="fr p1-6">
                            '.$price.'р.
                        </div>
                    </div>
                </div>
            </div>';
    }
    
    public function getButtonGold($key, $amount,  $price, $discount, $sale){
        return '
            <div onclick=buyGold('.$key.') class="p-3-0">
                <div class="w100 m1 bottonMini7p">
                    <div class="btn-link">
                        <div class="fl p6">
                            <img src="'.$this->game->url.'/img/icons/gold.png" class="vs" height="30">
                        </div>
                        <div class="fl">
                            <b><span class="discount tdlt">'.$amount.'</span></b>
                            <b>'.$discount.'</b>
                        </div>
                        <div class="fr p1-6">
                            '.($sale>0?'<span class="red">-'.$sale.'%</span>':'').'<img src="'.$this->game->url.'/img/icons/cristal.png" class="vs" height="20px">'.$price.'
                        </div>
                    </div>
                </div>
            </div>';
    }
    
    public function getButtonScroll($key, $name,$amount,  $price, $discount){
        return '
            <div onclick=buyScroll('.$key.') class="p-3-0">
                <div class="w100 m1 bottonMini7p">
                    <div class="btn-link">
                        <div class="fl p6">
                            <img src="'.$this->game->url.'/img/icons/'.$name.'.png" class="vs" height="30">
                        </div>
                        <div class="fl">
                            <b>'.$amount.'</b>
                        </div>
                        <div class="fr p1-6">
                            <img src="'.$this->game->url.'/img/icons/gold.png" class="vs" height="20px"><span class="discount tdlt">'.$price.'</span>
                            '.$discount.'
                        </div>
                    </div>
                </div>
            </div>';
    }
    
    public function getButtonClef($key, $name, $amount, $price, $discount){
        return '
            <div onclick=buyClef('.$key.') class="p-3-0">
                <div class="w100 m1 bottonMini7p">
                    <div class="btn-link">
                        <div class="fl p6">
                            <img src="'.$this->game->url.'/img/icons/'.$name.'.png" class="vs" height="30">
                        </div>
                        <div class="fl">
                            <b>'.$amount.'</b>
                        </div>
                        <div class="fr p1-6">
                            <img src="'.$this->game->url.'/img/icons/cristal.png" class="vs" height="20px"><span class="discount tdlt">'.$price.'</span>
                            '.$discount.'
                        </div>
                    </div>
                </div>
            </div>';
    }
}