<?php
namespace model;
class Quest{
    private $rewardIcon = [
            "cristal_reward"    =>"img/icons/cristal.png",
            "gold_reward"       =>"img/icons/gold.png", 
            "clef_reward"       =>"img/icons/clef.png",
            "scroll_reward"     =>"img/icons/scroll.png",
            "les_reward"        =>"img/icons/les.png",
            "kam_reward"        =>"img/icons/kam.png",
            "zel_reward"        =>"img/icons/zel.png",
            "eda_reward"        =>"img/icons/eda.png",
            "lud_reward"        =>"img/icons/lud.png"
        ];
    public function __construct(&$game){
        $this->game = $game;
    }
    public function inputReward(){
        $input = '';
        foreach ($this->rewardIcon as $key => $value) {
            $key = substr($key, 0, strpos($key, "_"));
            $input .= '
            <div class="p-3-0"><img src="'.$this->game->getUrl().'/'.$value.'" class="vs" height="25"></div>
            <input id="'.$key.'" type="text" maxlength="10"  name="name" value="0" class="form-inputPanelRed w70 left p-3-0"></input>';
        }
        return $input;
    }
    public function inputRewardEdit($arr){
        $input = '';
        foreach ($this->rewardIcon as $key => $value) {
            $key = substr($key, 0, strpos($key, "_"));
            foreach ($arr as $key2 => $value2) {
                $name = $key2;
                $key2 = substr($key2, 0, strpos($key2, "_"));
                if($key==$key2){
                    $input .= '
                <div class="p-3-0"><img src="'.$this->game->getUrl().'/'.$value.'" class="vs" height="25"></div>
                <input id="'.$key.'" type="text" maxlength="10"  name="name" value="'.$arr[$name].'" class="form-inputPanelRed w70 left p-3-0"></input>';   
                }
            }
            
        }
        return $input;
    }
    public function getCountControl(){
        $query = "
        SELECT count(*) col
        FROM `quest`";
		return $this->game->db->query($query,[])->fetch_assoc()["col"];
    }
    public function getCount($user){
        $query = "
        SELECT count(*) col
        FROM `quest`
        left JOIN (SELECT *  FROM `quest_user` WHERE user = {?} and done = 1  GROUP BY  `quest_id` ) `quest_select_user` ON `quest`.id  =`quest_select_user`.quest_id
        WHERE `quest_select_user`.quest_id is NULL and work = 1
		";
		return $this->game->db->query($query,[$user])->fetch_assoc()["col"];
    }
    public function done($id){
        $query = "UPDATE `quest_user` SET `done` = 1 WHERE `id` = {?}";
		$this->game->db->query($query,[$id]);   
    }
    public function plassUser($key, $count, $user){
        $query = "UPDATE `users` SET `".$key."` = `".$key."` + {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$count, $user]);   
    }
    public function plassCity($key, $count, $city){
        $query = "UPDATE `map` SET `".$key."` = `".$key."` + {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$count, $city]);   
    }
    public function choiceOfAward($quest, $key, $user, $city){
        $count = $quest[$key];
        $key = substr($key, 0, strpos($key, "_"));
        if($key == "les" or $key == "kam" or $key == "zel" or $key == "eda" or $key == "lud" or $key == "scroll"){
            $this->plassCity($key, $count, $city);
        }
        elseif($key == "cristal" or $key == "gold" or $key == "clef"){
            $this->plassUser($key, $count, $user);
        }
    } 
    public function issueAnAward($quest, $user, $city){
        $this->textReward = '';
        foreach ($this->rewardIcon as $key => $value) {
            if($quest[$key]>0){
                $this->textReward .= '<img src="'.$this->game->getUrl().'/'.$value.'" class="vs" height="25">'.$quest[$key].' ';  
                $this->choiceOfAward($quest, $key, $user, $city);
            }
        }
        return $this->textReward;
    }
    public function getReward($quest){
        $reward = '';
        foreach ($this->rewardIcon as $key => $value) {
            if($quest[$key]>0)
                $reward .= '<img src="'.$this->game->getUrl().'/'.$value.'" class="vs" height="25">'.$quest[$key].' ';
        }
        return $reward;
    }
    public function getListControl($start){
        $query = "
        SELECT `quest`.*
        FROM `quest`
        ORDER BY `quest`.position ASC LIMIT $start, 10";
        return $this->game->db->query($query,[]);
    }
    public function getList($user, $start){
        $query = "
        SELECT `quest`.*
        FROM `quest`
        left JOIN (SELECT *  FROM `quest_user` WHERE user = {?} and done = 1  GROUP BY  `quest_id` ) `quest_select_user` ON `quest`.id  =`quest_select_user`.quest_id
        WHERE `quest_select_user`.quest_id is NULL and work = 1
        ORDER BY `quest`.position DESC LIMIT $start, 10";
        return $this->game->db->query($query,[$user]);
    }
    public function addUserQuest($userId, $questId){
        $query = "INSERT INTO `quest_user` SET `user` = {?}, `quest_id` = {?}";
    	$this->game->db->query($query,[$userId, $questId]);
    }
    public function addOptionPost($id, $correct, $name){
        $query = "INSERT INTO `quest_option` SET `quest_id` = {?}, `correct` = {?}, `msg` = {?}";
    	$this->game->db->query($query,[$id, $correct, $name]);
    }
    public function updateOptionPost($id, $correct, $name){
        $query = "UPDATE `quest_option` SET `correct` = {?}, `msg` = {?} WHERE id = {?}";
    	$this->game->db->query($query,[$correct, $name, $id]);
    }
    public function deleteOptionPost($id){
        $query = "DELETE FROM `quest_option` WHERE  `id` = {?}";
        $this->game->db->query($query, [$id]);
    }
    
    public function deleteQuestId($id){
        $query = "DELETE FROM `quest` WHERE  `id` = {?}";
        $this->game->db->query($query, [$id]);
    }
    public function add($arr){
        $query = "INSERT INTO `quest` SET 
        `icon` = {?},
        `name` = {?}, 
        `msg` = {?}, 
        `question` = {?}, 
        `time_error` = {?}, 
        `cristal_reward` = {?}, 
        `gold_reward` = {?}, 
        `clef_reward` = {?}, 
        `scroll_reward` = {?}, 
        `les_reward` = {?}, 
        `kam_reward` = {?}, 
        `zel_reward` = {?}, 
        `eda_reward` = {?}, 
        `lud_reward` = {?}";
    	$this->game->db->query($query,$arr);
    }
    public function update($arr){
        $query = "UPDATE `quest` SET
        `work` = {?},
        `icon` = {?},
        `name` = {?}, 
        `msg` = {?}, 
        `question` = {?}, 
        `time_error` = {?}, 
        `cristal_reward` = {?}, 
        `gold_reward` = {?}, 
        `clef_reward` = {?}, 
        `scroll_reward` = {?}, 
        `les_reward` = {?}, 
        `kam_reward` = {?}, 
        `zel_reward` = {?}, 
        `eda_reward` = {?}, 
        `lud_reward` = {?},
        `position` = {?}
        WHERE `id` = {?}";
    	$this->game->db->query($query, $arr);
    }
    public function getSupport($userId){
        $query = "
        SELECT *
        FROM `support`
        WHERE user = {?} and quest = 1
        ";
        return $this->game->db->query($query,[$userId])->fetch_assoc();
    }
    public function getQuestUserId($userId, $questId){
        $query = "
        SELECT *
        FROM `quest_user`
        WHERE user = {?} and quest_id = {?}
        ";
        return $this->game->db->query($query,[$userId, $questId])->fetch_assoc();
    }
	public function setTimeUserQuest($questId, $time){
	    $query = "UPDATE `quest_user` SET `response_time` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$time, $questId]);   
	}
    public function getQuestOption($id){
        $query = "
        SELECT `quest_option`.*
        FROM `quest_option`
        WHERE `quest_option`.quest_id = {?}";
        return $this->game->db->query($query,[$id]);
    }
    public function chackEditId($id){
        
        $query = "
        SELECT `quest`.*
        FROM `quest`
        WHERE `quest`.id = {?}
        LIMIT 1";
        return $this->game->db->query($query,[$id])->fetch_assoc();
    }
    public function chackOptionId($id){
        $query = "
        SELECT `quest_option`.*
        FROM `quest_option`
        WHERE `quest_option`.id = {?}
        LIMIT 1";
        return $this->game->db->query($query,[$id])->fetch_assoc();
    }
    public function chackId($id, $user){
        
        $query = "
        SELECT `quest`.*
        FROM `quest`
        left JOIN (SELECT *  FROM `quest_user` WHERE user = {?} and done = 1  GROUP BY  `quest_id` ) `quest_select_user` ON `quest`.id  =`quest_select_user`.quest_id
        WHERE `quest_select_user`.quest_id is NULL and `quest`.id = {?}
        ORDER BY `quest`.id DESC LIMIT 1";
        return $this->game->db->query($query,[$user, $id])->fetch_assoc();
    }
    public function showViewButton($arr){
        return '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack" onclick="window.brouser.openPage(&quot;'.$this->game->getUrl().'/html/page/quest.php?'.$arr["url"].'&quot;,{})">
                <div class="table w100 tborder10-5"> 
        			<div class="white row">
        				<div class="cell w10">
        				    <div class="p6 w50px h50px">
        				        <div class="rel w100 h100">
        				            <div class="iconButtonCenter">
        				                <img src="'.$this->game->getUrl().'/'.$arr["icon"].'" class="vs wmax50px hmax50px">
        					        </div>
        					    </div>
        					</div>
        				</div>
        				<div class="cell fz20 left vam p6">
        				    <div class="fbold">'.$arr["name"].'</div>
        				</div>
        				<div class="cell fz20 right vam p6 ">
        				   <img src="'.$this->game->getUrl().'/img/icons/back.png" class="vs" height="30">
        				</div>
        			</div>
        		</div>
        	</div>
        </div>';
    }
}