<?php
namespace model;
class Rank{
    public $timerUpdate = 604800;
    public $rankName = [
        "Рядовой",
        "Ефрейтор",
        "Младший сержант",
        "Cержант",
        "Старший сержант",
        "Старшина",
        "Младший лейтенант",
        "Лейтенант",
        "Старший лейтенант",
        "Капитан",
        "Майор",
        "Подполковник",
        "Полковник",
        "Подполковник",
        "Генерал-майор",
        "Генерал-лейтенант",
        "Генерал-армии",
        "Маршал"
    ];
    public $prize = [
        ["gold" => 100, "cristal"=>1, "clef"=>100],//
        ["gold" => 200, "cristal"=>2, "clef"=>200],//
        ["gold" => 300, "cristal"=>3, "clef"=>300],//
        ["gold" => 400, "cristal"=>4, "clef"=>400],//
        ["gold" => 500, "cristal"=>5, "clef"=>500],//
        ["gold" => 600, "cristal"=>6, "clef"=>600],//
        ["gold" => 700, "cristal"=>7, "clef"=>700],//
        ["gold" => 800, "cristal"=>8, "clef"=>800],//
        ["gold" => 900, "cristal"=>9, "clef"=>900],//
        ["gold" => 1000, "cristal"=>10, "clef"=>1000],//
        ["gold" => 1100, "cristal"=>11, "clef"=>1100],//
        ["gold" => 1200, "cristal"=>12, "clef"=>1200],//
        ["gold" => 1300, "cristal"=>13, "clef"=>1300],//
        ["gold" => 1400, "cristal"=>14, "clef"=>1400],//
        ["gold" => 1500, "cristal"=>15, "clef"=>1500],//
        ["gold" => 1600, "cristal"=>16, "clef"=>1600],//
        ["gold" => 1700, "cristal"=>17, "clef"=>1700],//
        ["gold" => 1800, "cristal"=>18, "clef"=>1800]//
    ];
    public function __construct(&$game){
        $this->game = $game;
    }
    public function getXp($rank){
        if($rank>17)
            $rank = 17;
        return $rank*$rank*10*10;
    }
    public function getRank($xp){
        $rank = floor(sqrt($xp)/10);
        if($rank>17)
            $rank = 17;
        return $rank;
    }
    public function getProsent($xp, $nextXp){
        return floor($xp*100/$nextXp);
    }
    public function getRankName($id){
        return $this->rankName[$id];
    }
    public function getId($id, $user){
        $query = "SELECT * FROM `rank` WHERE `level` = {?} and `timer`> {?} and `user` = {?}";
        return $this->game->db->query($query, [$id, time(), $user])->fetch_assoc();
    }
    public function add($user, $timer, $level){
        $query = "INSERT INTO `rank` SET   `user` = {?}, `timer` = {?}, `level` = {?}";
    	$this->game->db->query($query,[$user, $timer, $level]);
    }
    public function getAll($user){
        $query = "SELECT * FROM `rank` WHERE  `timer`> {?} and `user` = {?}";
        return $this->game->db->query($query, [time(), $user]);
    }
}