<?php
namespace model;
class Rating{
    private $online = 180;//3 минуты
    public function __construct(&$game){
        $this->game = $game;
    }
    public function getUsersCount(){
        $query = "
        SELECT count(*) col
		FROM `users`";
		return $this->game->db->query($query,[])->fetch_assoc()["col"];
    }
    public function getUsers($start){
        $query = "
        SELECT users.id, users.nick , IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
        FROM `users`
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
        left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        ORDER BY rating DESC, users.id DESC LIMIT $start, 10";
        return $this->game->db->query($query, []);
    }
    public function getMyRank($id){
        $query = "
        SELECT  count(*) as rank, `my_user`.nick as nick, `my_user`.my_rating AS my_rating
        FROM(
        	SELECT  IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
            FROM `users`
            left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                       left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
                       GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
            left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
            left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        ) q
        left JOIN (SELECT users.id, users.nick, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS my_rating  FROM `users` 
        	left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
            left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
            left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                       left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
                       GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader        
                   
                
        GROUP BY  `id` ) `my_user` ON $id  = `my_user`.id
        WHERE rating>=(
        	SELECT  IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) 
            FROM `users`
            left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                       left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
                       GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
            left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
            left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
            WHERE `users`.id = $id
        )";
        return $this->game->db->query($query, [])->fetch_assoc();
    }
    public function getProvinces($start){
        $query = "
        SELECT 
        `users`.id, `users`.nick, 
        IFNULL(`invader_user`.col, 0) as invader_col, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
        FROM `users`
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                   left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
                   GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        ORDER BY invader_col DESC, users.id DESC LIMIT $start, 10";
        return $this->game->db->query($query, []);
    }
    public function getMyRankProvinces($id){
        $query = "
        SELECT  count(*) as rank, `my_user`.nick as nick, `my_user`.my_rating AS my_rating, `my_user`.col AS col
        FROM(
        	SELECT  IFNULL(`invader_user`.col, 0) AS invader_col
            FROM `users`
            left JOIN (SELECT id, count(id) col, invader FROM `map` 
                         
                       GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
           
        ) q
        left JOIN (SELECT users.id, users.nick, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS my_rating, IFNULL(`invader_user`.col, 0) AS col   FROM `users` 
        	left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
            left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
            left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                       left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
                       GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader
        GROUP BY  `id` ) `my_user` ON $id  = `my_user`.id
        WHERE invader_col>=(
        	SELECT  IFNULL(`invader_user`.col, 0) 
            FROM `users`
            left JOIN (SELECT id, count(id) col, invader FROM `map` 
                         
                       GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
            WHERE `users`.id = $id
        )";
        return $this->game->db->query($query, [])->fetch_assoc();
    }
    public function getUsersCountOnline(){
        $online = time()-$this->online;
        $query = "
        SELECT count(*) col
		FROM `users`
		WHERE `date_online`> {?}";
		return $this->game->db->query($query,[$online])->fetch_assoc()["col"];
    }
    public function getUsersOnline($start){
        $online = time()-$this->online;
        $query = "
        SELECT users.id, users.nick , IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
        FROM `users`
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
        left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        WHERE `date_online`> {?}
        ORDER BY rating DESC, users.id DESC LIMIT $start, 10";
        return $this->game->db->query($query, [$online]);
    }
    public function getUnionCount(){
        $query = "
        SELECT count(*) col
		FROM `alliance`";
		return $this->game->db->query($query,[])->fetch_assoc()["col"];
    }
    public function getUnion($start){
        $online = time()-$this->online;
        $query = "
        SELECT `alliance`.id, `alliance`.name, IFNULL(`alliance_users`.rating, 0) rating
        FROM `alliance`
        left JOIN (SELECT  alliance,  IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating  FROM `users`  
            left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
               	GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader
            left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
            left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        GROUP BY  `alliance` ) `alliance_users` ON `alliance`.id  = `alliance_users`.alliance
        ORDER BY rating DESC, `alliance`.id DESC LIMIT $start, 10";
        return $this->game->db->query($query, []);
    }
    public function getMyUnion($id){
        $query = "
        SELECT  count(*) as rank, `my_union`.name, `my_union`.rat AS rating
        FROM(
        	SELECT `alliance`.id, `alliance`.name, IFNULL(`alliance_users`.rating, 0) rating
            FROM `alliance`
            left JOIN (SELECT  alliance,  IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating  FROM `users`  
                left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                    left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
                    GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader
                left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
                left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
            GROUP BY  `alliance` ) `alliance_users` ON `alliance`.id  = `alliance_users`.alliance
        ) q
        left JOIN (SELECT id, name, `alliance_users`.rating AS rat FROM `alliance` 
        	left JOIN (SELECT  alliance,  IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating  FROM `users`  
                left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                    left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
                    GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader
                left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
                left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
            GROUP BY  `alliance` ) `alliance_users` ON `alliance`.id  = `alliance_users`.alliance
        GROUP BY  `id` ) `my_union` ON $id  = `my_union`.id
        WHERE rating>=(
        	SELECT IFNULL(`alliance_users`.rating, 0) rating
            FROM `alliance`
            left JOIN (SELECT  alliance,  IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating  FROM `users`  
                left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                    left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
                    GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader
                left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
                left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
            GROUP BY  `alliance` ) `alliance_users` ON `alliance`.id  = `alliance_users`.alliance
            WHERE alliance.id = $id
        )";
        return $this->game->db->query($query, [])->fetch_assoc();
    }
}