<?php
namespace model;
class Support{
    public function __construct(&$game){
        $this->game = $game;
    }
    public function getCountComments($id){
        $query = "
        SELECT count(*) col
		FROM `ticket_comment` 
		WHERE `ticket_comment`.ticket = {?}";
		return $this->game->db->query($query,[$id])->fetch_assoc()["col"];
    }
    public function getComments($id, $start){
        $query = "
        SELECT `ticket_comment`.*, `user_comment`.nick
		FROM `ticket_comment` 
		left JOIN (SELECT id, nick  FROM `users`  GROUP BY  `id` ) `user_comment` ON `ticket_comment`.user  =`user_comment`.id
		WHERE `ticket_comment`.ticket = {?}
		ORDER BY id DESC LIMIT $start, 10";
		return $this->game->db->query($query,[$id]);
    }
    public function getSupport(){
        $query = "
        SELECT `support`.*, `user_support`.nick, IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
        FROM `support` 
        left JOIN (SELECT invader, sum(`invader_rating`.summ) rating FROM `map` 
            left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
        GROUP BY  `invader` ) `invader_user` ON `support`.user  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `support` .user  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        left JOIN (SELECT id, nick  FROM `users`  GROUP BY  `id` ) `user_support` ON `support`.user  =`user_support`.id";
        return $this->game->db->query($query,[]);
    }
    public function addTicket($user, $theme, $msg){
        $query = "INSERT INTO `ticket` SET   `user` = {?}, `theme` = {?}, `msg` = {?}, `time` = {?}";
    	$this->game->db->query($query,[$user, $theme, $msg, time()]);
    }
    public function addComment($user, $ticket, $text){
        
        $query = "INSERT INTO `ticket_comment` SET `ticket` = {?}, `user` = {?}, `msg` = {?}, `timer`= {?}";
    	$this->game->db->query($query,[$ticket, $user, $text, time()]);
    }
    public function countTickets($user){
        $query = "
        SELECT count(*) col
		FROM `ticket`  
        WHERE `user` = {?}";
		return $this->game->db->query($query,[$user])->fetch_assoc()["col"];
    }
    public function countAdminTickets(){
        $query = "
        SELECT count(*) col
		FROM `ticket`  
        ";
		return $this->game->db->query($query,[])->fetch_assoc()["col"];
    }
    public function getAdminTickets($start){
        $query = "
        SELECT *
        FROM `ticket` 
        ORDER BY id DESC LIMIT $start, 10";
        return $this->game->db->query($query,[]);
    }
    public function getTicketId($user, $id){
        $query = "
        SELECT *
        FROM `ticket` 
        WHERE `user` = {?} and `id` = {?} limit 1";
        return $this->game->db->query($query,[$user, $id])->fetch_assoc();
    }
    public function getTicketAdminId($id){
        $query = "
        SELECT `ticket`.*, `user_nick`.nick
        FROM `ticket` 
        left JOIN (SELECT id, nick  FROM `users`  GROUP BY  `id` ) `user_nick` ON `ticket`.user  =`user_nick`.id
        WHERE `ticket`.id = {?} limit 1";
        return $this->game->db->query($query,[$id])->fetch_assoc();
    }
    public function getTickets($userId, $start){
        $query = "
        SELECT *
        FROM `ticket` 
        WHERE `user` = {?}
        
        ORDER BY id DESC LIMIT $start, 10";
        return $this->game->db->query($query,[$userId]);
    }
    public function getAccessSupport($userId){
        $query = "
        SELECT *
        FROM `support`
        WHERE user = {?} and support = 1
        ";
        return $this->game->db->query($query,[$userId])->fetch_assoc();
    }
    public function setClosed($id, $state){
        $query = "UPDATE `ticket` SET `closed` = {?} WHERE `id` = {?}";
		$this->game->db->query($query,[$state, $id]);   
    }
}