<?php
namespace model;
class User{
    public function __construct(&$game){
        $this->game = $game;
    }
    public function getById($id){
        $query = "
        SELECT 
        `users`.id, `users`.nick,  `users`.alliance, 
        IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating,
        IFNULL(`invader_user`.col, 0) as invader_col, `user_map`.id as city_id, `user_map`.x as x, `user_map`.y as y,
        `user_union`.name AS union_name, `user_union_position`.name AS union_position
        FROM `users`
        left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
        left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
       	GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
        left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
        left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        left JOIN (SELECT id, name  FROM `alliance`  GROUP BY  `id` ) `user_union` ON `users`.alliance  = `user_union`.id
        left JOIN (SELECT user, name  FROM `alliance_position`  GROUP BY  `user` ) `user_union_position` ON `users`.id = `user_union_position`.user
        WHERE `users`.id = {?}";
        return $this->game->db->query($query, [$id])->fetch_assoc();
    }
    

    public function getByDome($id){
        $query = "SELECT * FROM `users` WHERE id = {?}";
        return $this->game->db->query($query, [$id])->fetch_assoc();
    }
    
    public function getProvinces($id, $start){
        $query = "
        SELECT `map`.id, `map`.x, `map`.y,  `build_map`.level_sum as rating,
        `user_map`.nick as nick
        FROM `map` 
        left JOIN (SELECT city, sum(level) level_sum  FROM `build`  GROUP BY  `city` ) `build_map` ON `map`.id  = `build_map`.city 
        left JOIN (SELECT id, nick  FROM `users`  GROUP BY  `id` ) `user_map` ON `map`.user  = `user_map`.id 
        WHERE `map` .invader = {?}
        ORDER BY rating DESC LIMIT ".$start.", 10";
        return $this->game->db->query($query, [$id]);
    }
    public function getRank($id){
        $query = "
        SELECT  count(*) as rank
        FROM(
        	SELECT  IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) AS rating
            FROM `users`
            left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                       left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
                       GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
            left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
            left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
        ) q
        WHERE rating>=(
        	SELECT  IFNULL(`invader_user`.rating, 0)+IFNULL(`user_build`.summ, 0) 
            FROM `users`
            left JOIN (SELECT id, invader, count(id) col, sum(`invader_rating`.summ) rating FROM `map` 
                       left JOIN (SELECT city, sum(level) summ FROM `build`  GROUP BY  `city` ) `invader_rating` ON `id`  = `invader_rating`.city  
                       GROUP BY  `invader` ) `invader_user` ON `users`.id  = `invader_user`.invader 
            left JOIN (SELECT id, user, x, y  FROM `map`  GROUP BY  `user` ) `user_map` ON `users`.id  = `user_map`.user
            left JOIN (SELECT city, sum(`level`) summ  FROM `build`  GROUP BY  `city` ) `user_build` ON `user_map`.id  = `user_build`.city
            WHERE `users`.id = $id
        )";
        return $this->game->db->query($query, [])->fetch_assoc()["rank"];
    }
    public function chackInvitation($user, $union){
        $query = "SELECT * FROM `alliance_invitation` WHERE `user` = {?} and `alliance` = {?}";
        return $this->game->db->query($query, [$user, $union])->fetch_assoc();
    }
    public function addInvitation($user, $union){
        $query = "INSERT INTO `alliance_invitation` SET `alliance` = {?}, `user` = {?}";
    	$this->game->db->query($query,[$union, $user]);
    }
}