<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Box extends \engine\Game{
    private $top = 'Сокровище';
    private $html = '';
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\Box($this);
        $this->modelTreasury = new \model\Treasury($this);
        $this->modelMarket = new \model\Market($this);
    }
    private function showMiniBox(){
        $this->textMiniBox = '';
        foreach ($this->model->miniBox as $key => $value) {
            $this->textMiniBox .= '
            <div class="p-5-10 fz20">
                <div class="redPanel p-5-10 redPanelBack" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/box.php?box='.$key.'&quot;,{})">
                    <div class="table w100 tborder10-5"> 
            			<div class="white row">
            				<div class="cell w10">
            				    <div class="p6">
            				        <img src="'.\engine\Engine::getInstance()->game->url.'/img/box/'.$key.'.png" class="vs" height="50">
            					</div>
            				</div>
            				<div class="cell fz20 left vam p6">
            				    '.$this->model->miniBox[$key]["name"].'
            				</div>
            				<div class="cell fz20 right vam p6 ">
            				    <img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/clef.png" class="vs" height="20px">'.$this->model->miniBox[$key]["price"].'
            				</div>
            			</div>
            		</div>
            	</div>
            </div>';
        }
    }
    
    private function main(){
        $this->top = 'Сокровище';
        $largeSql = $this->model->selectLarge($this->user->getParam("id"));
        $clef = $largeSql["clef"];
        $price = $this->model->largeBox["price"];
        $procent = $this->model->getProcent($price, $clef);
        $this->showMiniBox();
        $this->html = 
        $this->modelTreasury->getPanelClef().'
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack">
                <div class="table w100 tborder10-5" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/box.php?large&quot;,{})"> 
        			<div class="white row">
        				<div class="cell">
        				    <div class="p6">
        				        <img src="'.\engine\Engine::getInstance()->game->url.'/img/box/3.png" class="vs" height="50">
        					</div>
        				</div>
        				<div class="cell fz20 center vam p6 w100">
        				    '.$this->model->largeBox["name"].'
        				    <div class="fr w100  scaleXpGreen" style="height: 26px;">
                                <div class="rel">
                                    <div class="absolute w90 scaleXp" style="height: 26px;width: '.$procent.'%;">
                                    </div>
                                    <div class="absolute center w100">
                                        <img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/clef.png" class="vs" height="20px">'.$clef.' / '.$price.'
                                    </div>
                                </div>
                            </div>
        				</div>
        			</div>
        		</div>
        	</div>
        </div>
        '.$this->textMiniBox;
    }
    private function goOpenMini(){
        $this->largeSql = $this->model->selectLarge($this->user->getParam("id"));
        $goodPresent    = $this->model->randRewar($this->model->miniBox[$this->boxId]["present"]);
        $textRewarOpen  = $this->model->setRewar($goodPresent);
        $this->view->getButtonQuestionBlueOk('Награда', $textRewarOpen, '"window.brouser.openPage(&quot;'.$this->url.'/html/page/box.php?box='.$this->boxId.'&quot;,{}, false)"');
        $this->modelMarket->minusClef($this->user->getParam("id"), $this->model->miniBox[$this->boxId]["price"]);
        $this->model->plassBox($this->largeSql["id"], $this->model->miniBox[$this->boxId]["price"]);
    }
    private function openMini(){
        if($this->user->getParam("clef")>=$this->model->miniBox[$this->boxId]["price"])
            $this->goOpenMini();
        else
            $this->view->addMessRed('Ошибка', 'Нехватает <img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/clef.png" class="vs" height="20px">'.($this->model->miniBox[$this->boxId]["price"]-$this->user->getParam("clef")));       
    }
    private function showBoxId(){
        $this->boxId    = intval($_GET["box"]);
        $this->top      = $this->model->miniBox[$this->boxId]["name"];
        if(isset($_GET["open"]))
            $this->openMini();  
        $textReward = $this->model->showRewardText($this->model->miniBox[$this->boxId]["present"]);
        $this->html     = 
        $this->modelTreasury->getPanelClef().'
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack white center">
                <div class="fz20 center">
                    <img src="'.\engine\Engine::getInstance()->game->url.'/img/box/'.$this->boxId.'.png" class="vs" height="50"><br>
                    Может содержать:
                </div>
                <div class="fz15 left blacPanelRedButton p-5-10 borderRadius5px">
                    '.$textReward.'
                </div>
                <div class="p10-0">
        			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/box.php?box='.$this->boxId.'&open&quot;,{}, false)">
        		        Открыть <img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/clef.png" class="vs" height="20px">'.$this->model->miniBox[$this->boxId]["price"].'
        		    </div>
    		    </div>
            </div>
        </div>
        ';
    }
    private function errorBoxId(){
        $this->top  = 'Ошибка';
        $this->html = '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack white center">
                Сундук не найден
            </div>
        </div>';
    }
    private function routerGetBox(){
        if (array_key_exists($_GET["box"], $this->model->miniBox))
            $this->showBoxId();
        else
            $this->errorBoxId();
    }
    private function goOpenLarge(){
        $goodPresent    = $this->model->randRewar($this->model->largeBox["present"]);
        $textRewarOpen  = $this->model->setRewar($goodPresent);
        $this->view->getButtonQuestionBlueOk('Награда', $textRewarOpen, '"window.brouser.openPage(&quot;'.$this->url.'/html/page/box.php?large&quot;,{}, false)"');
        $this->model->minusBox($this->largeSql["id"], $this->model->largeBox["price"]);
    }
    private function OpenLarge(){
        if($this->largeSql["clef"]>=$this->model->largeBox["price"])
            $this->goOpenLarge();
        else
            $this->view->addMessRed('Ошибка', 'Откройте ещё сундуков на <img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/clef.png" class="vs" height="20px">'.($this->model->largeBox["price"]-$this->largeSql["clef"]));       
    }
    private function large(){
        $this->top = $this->model->largeBox["name"];
        
        $this->largeSql = $this->model->selectLarge($this->user->getParam("id"));
        if(isset($_GET["open"]))
            $this->openLarge();
        $clef = $this->largeSql["clef"];
        $price = $this->model->largeBox["price"];
        $procent = $this->model->getProcent($price, $clef);
        $textReward = $this->model->showRewardText($this->model->largeBox["present"]);
        $this->html = '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack white center">
                <div class="fz20 center">
                    <div class="table w100" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/box.php?large&quot;,{})"> 
            			<div class="white row">
            				<div class="cell">
            				    <div class="p6">
            				        <img src="'.\engine\Engine::getInstance()->game->url.'/img/box/3.png" class="vs" height="50">
            					</div>
            				</div>
            				<div class="cell fz20 right vam p6 w100">
            				    <div class="fr w100  scaleXpGreen" style="height: 26px;">
                                    <div class="rel">
                                        <div class="absolute w90 scaleXp" style="height: 26px;width: '.$procent.'%;">
                                        </div>
                                        <div class="absolute center w100">
                                            <img src="'.\engine\Engine::getInstance()->game->url.'/img/icons/clef.png" class="vs" height="20px">'.$clef.' / '.$price.'
                                        </div>
                                    </div>
                                </div>
            				</div>
            			</div>
            		</div>
                    Может содержать:
                </div>
                <div class="fz15 left blacPanelRedButton p-5-10 borderRadius5px">
                    '.$textReward.'
                </div>
                <div class="p10-0">
        			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/box.php?large&open&quot;,{}, false)">
        		        Открыть 
        		    </div>
    		    </div>
            </div>
        </div>
        ';
    }
    private function router(){
        if(isset($_GET["box"]))
            $this->routerGetBox();
        elseif(isset($_GET["large"]))
            $this->large();
        else
            $this->main();
    }
    public function setView(){
        $this->router();
        $this->view->addTop($this->top);
        $this->view->setNavigator();
        $this->view->addBody($this->html);
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}