<?php
namespace page;

$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');

class Chat extends \engine\Game {
    private $top = 'Чат';
    private $html = '';

    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->rank = new \model\Rank($this);
    }

    private function start(){
        $this->showMain();
    }

    private function addMsg(){
        $query = "INSERT INTO chat (user, msg, time) VALUES ({?}, {?}, {?})";
        $this->db->query($query, [$this->user->getParam("id"), $this->text, time()]);
    }

    private function sendMsg(){
        $this->text = htmlspecialchars($_POST["text"]);
        $msg = '';
        if(trim($this->text) != ''){
            $this->addMsg();
        } else $msg = 'Введите сообщение';
        if($msg!='') $this->view->addError("Ошибка", $msg);
    }

    private function showNewMsg(){
        if(isset($_POST["text"])) $this->sendMsg();

        $this->view->addScript($this->smile->showSmile($this->url));
        $form = $this->smile->getForm('/html/page/chat.php');

        $form = preg_replace_callback('/<input([^>]+)type="text"([^>]+)>/',
    function($matches) {
        $attrs = $matches[1] . $matches[2];
        $attrs = str_replace(['name="text"', 'value=""'], '', $attrs);

        return '
        <div class="chat-input-box">
            <textarea name="text"'.$attrs.'
                class="chat-textarea"
                placeholder="Введите ваше сообщение..."
                oninput="updateCharCounter(this)"></textarea>
            <div class="char-counter">0</div>
        </div>

        <style>
            .chat-input-box {
                width: 100%;
                position: relative;
            }
            .chat-textarea {
                width: 100%;
                min-height: 70px;
                padding: 8px;
                padding-right: 40px;  /* запас справа */
                padding-bottom: 25px; /* запас снизу */
                border: 2px solid #d17b46;
                border-radius: 10px;
                resize: vertical;
                font-family: inherit;
                font-size: 14px;
                box-sizing: border-box;
                background: #fff4e6;
                color: #5a2a00;
                outline: none;
            }
            .chat-textarea:focus {
                border: 2px solid #b34700;
                box-shadow: 0 0 5px rgba(179,71,0,0.4);
            }
            .char-counter {
                position: absolute;
                bottom: 6px;
                right: 12px;
                font-size: 11px;
                color: rgba(90,42,0,0.6); /* полупрозрачный */
                pointer-events: none;
                user-select: none;
            }
        </style>

        <script>
            function updateCharCounter(textarea) {
                var counter = textarea.parentElement.querySelector(".char-counter");
                counter.textContent = textarea.value.length;
            }
            document.addEventListener("DOMContentLoaded", function() {
                var textareas = document.querySelectorAll("textarea[name=\'text\']");
                textareas.forEach(function(textarea) {
                    updateCharCounter(textarea);
                    textarea.addEventListener("input", function() {
                        updateCharCounter(this);
                    });
                });
            });
        </script>';
    }, $form);

        $this->newMsg = '<div class="chat-input-container" style="width:100%;">'.$form.'</div>';
    }

    private function showMain(){
        $this->smile = new \engine\Smile();
        $this->showNewMsg();

        $query = "SELECT count(*) col FROM chat";
        $count = $this->db->query($query, [])->fetch_assoc()["col"];
        $k_page = \engine\Page::k_page($count, 20);
        $page = \engine\Page::page($k_page);
        $start = 20 * $page - 20;

        $query = "SELECT chat.*, users.nick AS nick, users.xp AS xp, users.id AS userId,
                  IFNULL(invader_user.rating, 0)+IFNULL(user_build.summ, 0) AS rating
                  FROM chat
                  LEFT JOIN users ON users.id = chat.user
                  LEFT JOIN (
                      SELECT id, invader, count(id) col, sum(invader_rating.summ) rating
                      FROM map
                      LEFT JOIN (
                          SELECT city, sum(level) summ FROM build GROUP BY city
                      ) invader_rating ON id = invader_rating.city
                      GROUP BY invader
                  ) invader_user ON chat.user = invader_user.invader
                  LEFT JOIN (
                      SELECT id, user, x, y FROM map GROUP BY user
                  ) user_map ON chat.user = user_map.user
                  LEFT JOIN (
                      SELECT city, sum(level) summ FROM build GROUP BY city
                  ) user_build ON user_map.id = user_build.city
                  ORDER BY chat.id DESC LIMIT $start, 20";

        $result = $this->db->query($query, []);

        $this->html .= $this->newMsg.' </br><hr> <div id="chat" class="p-0-10 white">';

        if($result->num_rows != 0){
            while($q = $result->fetch_assoc()){
                if((time()-$q["time"]) == 0) $timeText = 'Сейчас';
                else $timeText = $this->timer->tl(time()-$q["time"]);

                $this->html .= '
                <div class="msg">
                    <div class="table w100">
                        <div class="white row">
                            <div class="cell w50 fz20">
                                <img src="'.\engine\Engine::getInstance()->game->url.'/img/rank/'.$this->rank->getRank($q["rating"]).'.png"
                                     class="vs" height="25">
                                <span class="textUnder fBold"
                                    onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$q["user"].'})">
                                    '.$q["nick"].'
                                </span>
                            </div>
                            <div class="cell fz15 right">'.$timeText.'</div>
                        </div>
                    </div>
                    <div class="fz15" style="white-space:pre-wrap; word-wrap:break-word; overflow-wrap:break-word;">'.
                        \engine\Smile::text_msg($q["msg"]).'
                    </div>
                </div>';
            }
        } else {
            $this->html= '<div class="p-5-10 fz20 center">Нет сообщений</div>';
        }

        $this->body .= '</div>';
    }

    public function setView(){
        $this->start();
        $this->view->addTop($this->top);
        $this->view->setNavigator();
        $this->view->addBody($this->html);
        $this->view->setType('html');
        $this->view->echoEver();
    }
}