<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Help extends \engine\Game{
    private $html = '';
    private $top  = '';
    private $index = [
        ["name" => "О Третьем Риме", "icon" => "../icon.png",  "url" => "about"],
        ["name" => "Постройки", "icon" => "/img/build/lud.png",  "url" => "build"],
        ["name" => "Юниты", "icon" => "/img/arms/1.png",  "url" => "unit"],
        ["name" => "Ресурсы", "icon" => "/img/icons/gold.png",  "url" => "res"],
        ["name" => "Провинции", "icon" => "/img/icons/provinces.png", "url" => "provinces"],
        ["name" => "Звания", "icon" => "img/rank/10.png",  "url" => "rank"],
        ["name" => "Союз", "icon" => "/img/icons/union.png",  "url" => "union"],
        ["name" => "Война", "icon" => "/img/icons/reinforcement.png", "url" => "war"],
        ["name" => "Купол", "icon" => "/img/icons/cupol.png", "url" => "cupol"],
        ["name" => "Строитель", "icon" => "/img/icons/builder.png", "url" => "builder"]
    ];
    
    private $builds = [
        ["name" => "Капитолий", "icon" => "/img/build/townHall.png", "id" => "capitol", "description" => "Главное здание города. Определяет уровень развития и доступность других построек. Улучшение капитолия открывает новые возможности."],
        ["name" => "Лесопилка", "icon" => "/img/build/les.png", "id" => "sawmill", "description" => "Производит древесину - основной строительный материал. Уровень влияет на количество производимой древесины."],
        ["name" => "Каменный завод", "icon" => "/img/build/kam.png", "id" => "quarry", "description" => "Добывает камень для строительства укреплений и зданий. Необходим для развития города."],
        ["name" => "Металлургический завод", "icon" => "/img/build/zel.png", "id" => "foundry", "description" => "Производит железо для вооружения армии. Требует значительных инвестиций."],
        ["name" => "Ферма", "icon" => "/img/build/eda.png", "id" => "farm", "description" => "Обеспечивает продовольствием население. Нехватка приводит к снижению производительности."],
        ["name" => "Усадьба", "icon" => "/img/build/lud.png", "id" => "manor", "description" => "Увеличивает максимальное количество населения. Каждый уровень позволяет содержать больше жителей."],
        ["name" => "Склад", "icon" => "/img/build/storage.png", "id" => "warehouse", "description" => "Хранит ресурсы. Увеличение уровня повышает вместимость."],
        ["name" => "Лагерь", "icon" => "/img/build/staff.png", "id" => "camp", "description" => "Обеспечивает базовую подготовку новобранцев. Необходим для найма войск."],
        ["name" => "Казарма", "icon" => "/img/build/barracks.png", "id" => "barracks", "description" => "Позволяет тренировать профессиональных воинов. Открывает доступ к сильным юнитам."],
        ["name" => "Храм", "icon" => "/img/build/church.png", "id" => "temple", "description" => "Повышает мораль жителей и войск. Дает бонусы к защите."],
        ["name" => "Дипломатический центр", "icon" => "/img/build/diplomat.png", "id" => "embassy", "description" => "Позволяет заключать союзы и торговые соглашения."],
        ["name" => "Рынок", "icon" => "/img/build/market.png", "id" => "market", "description" => "Дает возможность обмениваться ресурсами с другими игроками."],
        ["name" => "Университет", "icon" => "/img/build/university.png", "id" => "university", "description" => "Позволяет исследовать новые технологии. Дает постоянные бонусы."]
    ];
    
    private $units = [
        ["name" => "Мечник", "icon" => "/img/arms/0.png", "id" => "swordsman", "description" => "Базовая пехотная единица. Сбалансирован между атакой и защитой. Эффективен против копейщиков."],
        ["name" => "Лучник", "icon" => "/img/arms/1.png", "id" => "archer", "description" => "Дальнобойный юнит. Наносит урон на расстоянии. Уязвим для кавалерии."],
        ["name" => "Копьеносец", "icon" => "/img/arms/2.png", "id" => "spearman", "description" => "Специализирован против кавалерии. Имеет бонус против конных юнитов."],
        ["name" => "Колесница", "icon" => "/img/arms/3.png", "id" => "chariot", "description" => "Быстрая кавалерия. Идеальна для фланговых атак. Слаба против копейщиков."],
        ["name" => "Баллиста", "icon" => "/img/arms/4.png", "id" => "ballista", "description" => "Осадное оружие. Эффективна против зданий. Требует защиты."]
    ];
    
    private $resurs = [
        ["name" => "Кристаллы", "icon" => "/img/icons/cristal.png", "id" => "crystals", "description" => "Редкий стратегический ресурс. Используется для особых построек и ускорения процессов."],
        ["name" => "Золото", "icon" => "/img/icons/gold.png", "id" => "gold", "description" => "Основная валюта игры. Требуется для найма войск, торговли и дипломатии."],
        ["name" => "Свитки", "icon" => "/img/icons/scroll.png", "id" => "scrolls", "description" => "Знания и технологии. Необходимы для исследований в Университете."],
        ["name" => "Ключи", "icon" => "/img/icons/clef.png", "id" => "keys", "description" => "Магические артефакты. Открывают доступ к особым локациям и сокровищам."],
        ["name" => "Дерево", "icon" => "/img/icons/les.png", "id" => "wood", "description" => "Основной строительный материал. Используется во всех зданиях."],
        ["name" => "Камень", "icon" => "/img/icons/kam.png", "id" => "stone", "description" => "Прочный материал для укреплений и продвинутых зданий."],
        ["name" => "Железо", "icon" => "/img/icons/zel.png", "id" => "iron", "description" => "Стратегический ресурс для вооружения армии."],
        ["name" => "Еда", "icon" => "/img/icons/eda.png", "id" => "food", "description" => "Поддерживает население и армию. Нехватка приводит к голоду."],
        ["name" => "Люди", "icon" => "/img/icons/lud.png", "id" => "people", "description" => "Население города. Требуется для работы зданий и пополнения армии."]
    ];

    private $union = [
        ["name" => "Приглашение", "icon" => "/img/icons/union.png", "id" => "invite", "description" => "Присоединяйтесь к существующему союзу для совместного развития и защиты."],
        ["name" => "Создание союза", "icon" => "/img/icons/union.png", "id" => "create", "description" => "Создайте собственный союз. Требует значительных ресурсов."],
        ["name" => "Состав", "icon" => "/img/icons/rank.png", "id" => "members", "description" => "Просмотр членов союза, их активности и вклада."],
        ["name" => "Устав", "icon" => "/img/icons/statute.png", "id" => "rules", "description" => "Правила и законы вашего союза. Устанавливает требования и нормы."],
        ["name" => "Должности", "icon" => "/img/icons/position.png", "id" => "positions", "description" => "Система рангов внутри союза. Дает права и обязанности."],
        ["name" => "Журнал", "icon" => "/img/icons/notice.png", "id" => "log", "description" => "История действий союза: войны, дипломатия, события."]
    ];

    private $war = [
        ["name" => "Как воевать?", "icon" => "/img/icons/attack.png", "id" => "howto", "description" => "Основы военного искусства: формирование армии, тактика боя, использование местности."],
        ["name" => "Игроки", "icon" => "/img/map/1.png", "id" => "players", "description" => "Атака других игроков для захвата ресурсов и территорий."],
        ["name" => "Варвары", "icon" => "/img/map/barbars.png", "id" => "barbarians", "description" => "Нейтральные враждебные юниты. Дают опыт и ресурсы при победе."]
    ];

    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\Help($this);
    }

    private function showAbout(){
        $this->top = 'О Третьем Риме';
        $this->html = '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack">
               "Третий Рим" - стратегическая браузерная игра, где вы сможете построить свою империю, развивать города, формировать армии и заключать союзы. Игра сочетает элементы градостроительства, военной стратегии и дипломатии.
            </div>
        </div>';
    }

    private function showBuild(){
        $this->top = 'Постройки';
        $buttons = '';
        foreach ($this->builds as $build) {
            $buttons .= $this->model->showViewButton([
                'name' => $build['name'],
                'icon' => $build['icon'],
                'url' => 'build&id='.$build['id'],
                'description' => $build['description']
            ]);
        }
        $this->html = $buttons;
    }

    private function showBuildDetail($id){
        foreach ($this->builds as $build) {
            if ($build['id'] == $id) {
                $this->top = $build['name'];
                $this->html = '
                <div class="p-5-10 fz20">
                    <div class="redPanel p-5-10 redPanelBack">
                        <img src="'.$build['icon'].'" style="height:50px; float:left; margin-right:15px;">
                        <h2>'.$build['name'].'</h2>
                        <div style="clear:both;"></div>
                        <p>'.$build['description'].'</p>
                    </div>
                </div>';
                return;
            }
        }
        $this->showBuild();
    }

    private function showUnits(){
        $this->top = 'Юниты';
        $buttons = '';
        foreach ($this->units as $unit) {
            $buttons .= $this->model->showViewButton([
                'name' => $unit['name'],
                'icon' => $unit['icon'],
                'url' => 'unit&id='.$unit['id'],
                'description' => $unit['description']
            ]);
        }
        $this->html = $buttons;
    }

    private function showUnitDetail($id){
        foreach ($this->units as $unit) {
            if ($unit['id'] == $id) {
                $this->top = $unit['name'];
                $this->html = '
                <div class="p-5-10 fz20">
                    <div class="redPanel p-5-10 redPanelBack">
                        <img src="'.$unit['icon'].'" style="height:50px; float:left; margin-right:15px;">
                        <h2>'.$unit['name'].'</h2>
                        <div style="clear:both;"></div>
                        <p>'.$unit['description'].'</p>
                    </div>
                </div>';
                return;
            }
        }
        $this->showUnits();
    }

    private function showRes(){
        $this->top = 'Ресурсы';
        $buttons = '';
        foreach ($this->resurs as $resource) {
            $buttons .= $this->model->showViewButton([
                'name' => $resource['name'],
                'icon' => $resource['icon'],
                'url' => 'res&id='.$resource['id'],
                'description' => $resource['description']
            ]);
        }
        $this->html = $buttons;
    }

    private function showResDetail($id){
        foreach ($this->resurs as $resource) {
            if ($resource['id'] == $id) {
                $this->top = $resource['name'];
                $this->html = '
                <div class="p-5-10 fz20">
                    <div class="redPanel p-5-10 redPanelBack">
                        <img src="'.$resource['icon'].'" style="height:50px; float:left; margin-right:15px;">
                        <h2>'.$resource['name'].'</h2>
                        <div style="clear:both;"></div>
                        <p>'.$resource['description'].'</p>
                    </div>
                </div>';
                return;
            }
        }
        $this->showRes();
    }

    private function showProvinces(){
        $this->top = 'Провинции';
        $this->html = '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack">
               Провинции представляют собой территории, которые можно захватывать и развивать. Каждая провинция дает уникальные бонусы и ресурсы. Управление провинциями - ключ к могуществу вашей империи.
            </div>
        </div>';
    }

    private function showRank(){
        $this->top = 'Звание';
        $this->html = '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack">
               Система званий отражает ваш прогресс в игре. С повышением звания открываются новые возможности, увеличиваются лимиты войск и доступ к особым функции. Звания присваиваются автоматически при достижении определенных условий.
            </div>
        </div>';
    }

    private function showUnion(){
        $this->top = 'Союз';
        $buttons = '';
        foreach ($this->union as $item) {
            $buttons .= $this->model->showViewButton([
                'name' => $item['name'],
                'icon' => $item['icon'],
                'url' => 'union&id='.$item['id'],
                'description' => $item['description']
            ]);
        }
        $this->html = $buttons;
    }

    private function showUnionDetail($id){
        foreach ($this->union as $item) {
            if ($item['id'] == $id) {
                $this->top = $item['name'];
                $this->html = '
                <div class="p-5-10 fz20">
                    <div class="redPanel p-5-10 redPanelBack">
                        <img src="'.$item['icon'].'" style="height:50px; float:left; margin-right:15px;">
                        <h2>'.$item['name'].'</h2>
                        <div style="clear:both;"></div>
                        <p>'.$item['description'].'</p>
                    </div>
                </div>';
                return;
            }
        }
        $this->showUnion();
    }

    private function showWar(){
        $this->top = 'Война';
        $buttons = '';
        foreach ($this->war as $item) {
            $buttons .= $this->model->showViewButton([
                'name' => $item['name'],
                'icon' => $item['icon'],
                'url" => "war&id='.$item['id'],
                'description' => $item['description']
            ]);
        }
        $this->html = $buttons;
    }

    private function showWarDetail($id){
        foreach ($this->war as $item) {
            if ($item['id'] == $id) {
                $this->top = $item['name'];
                $this->html = '
                <div class="p-5-10 fz20">
                    <div class="redPanel p-5-10 redPanelBack">
                        <img src="'.$item['icon'].'" style="height:50px; float:left; margin-right:15px;">
                        <h2>'.$item['name'].'</h2>
                        <div style="clear:both;"></div>
                        <p>'.$item['description'].'</p>
                    </div>
                </div>';
                return;
            }
        }
        $this->showWar();
    }

    private function showCupol(){
        $this->top = 'Купол защиты';
        $this->html = '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack">
                <img src="/img/icons/cupol.png" style="height:50px; float:left; margin-right:15px;">
                <h2>Купол защиты</h2>
                <div style="clear:both;"></div>
                <p>Защита нового игрока от нападений в течение 3х суток после регистрации. Купол автоматически активируется при создании аккаунта и предотвращает любые атаки со стороны других игроков. Игрок под защитой купола не может быть атакован, но также не может атаковать других игроков. Купол снимается автоматически по истечении 72 часов или при нападении на другого игрока.</p>
            </div>
        </div>';
    }

    private function showBuilder(){
        $this->top = 'Строитель';
        $this->html = '
        <div class="p-5-10 fz20">
            <div class="redPanel p-5-10 redPanelBack">
                <img src="/img/icons/builder.png" style="height:50px; float:left; margin-right:15px;">
                <h2>Строитель</h2>
                <div style="clear:both;"></div>
                <p>Дополнительный строитель, который позволяет одновременно вести больше строительных работ. Каждый дополнительный строитель увеличивает количество одновременно строящихся зданий. Этого строителя можно приобрести за кристаллы в магазине. Наличие дополнительного строителя значительно ускорит развитие вашей империи!</p>
            </div>
        </div>';
    }
    
    private function showIndex(){
        $this->top = 'Справка';
        $buttons = '';
        foreach ($this->index as $value){
            $buttons .= $this->model->showViewButton($value);
        }
        $this->html = $buttons;
    }

    private function routeIndex(){
        if(isset($_GET["about"])) {
            $this->showAbout();
        }
        elseif(isset($_GET["build"])) {
            if(isset($_GET["id"])) {
                $this->showBuildDetail($_GET["id"]);
            } else {
                $this->showBuild();
            }
        }
        elseif(isset($_GET["unit"])) {
            if(isset($_GET["id"])) {
                $this->showUnitDetail($_GET["id"]);
            } else {
                $this->showUnits();
            }
        }
        elseif(isset($_GET["res"])) {
            if(isset($_GET["id"])) {
                $this->showResDetail($_GET["id"]);
            } else {
                $this->showRes();
            }
        }
        elseif(isset($_GET["provinces"])) {
            $this->showProvinces();
        }
        elseif(isset($_GET["rank"])) {
            $this->showRank();
        }
        elseif(isset($_GET["union"])) {
            if(isset($_GET["id"])) {
                $this->showUnionDetail($_GET["id"]);
            } else {
                $this->showUnion();
            }
        }
        elseif(isset($_GET["war"])) {
            if(isset($_GET["id"])) {
                $this->showWarDetail($_GET["id"]);
            } else {
                $this->showWar();
            }
        }
        elseif(isset($_GET["cupol"])) {
            $this->showCupol();
        }
        elseif(isset($_GET["builder"])) {
            $this->showBuilder();
        }
        else {
            $this->showIndex();
        }
    }

    public function setView(){
        $this->routeIndex();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}