<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class passText extends \engine\Game{
    private $html = '';
    private $top  = 'Сменить кодовое слово';
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\passText($this);
    }
    private function replace(){
        $err = '';
        $new = $_POST["passText_1"];
        $repeat = $_POST["passText_2"];

        if(empty($new))
            $err = 'Введите новое кодовое слово';
        elseif(empty($repeat))
            $err = 'Введите повтор кодового слово';
        elseif(strlen($new) < 6 || strlen($new) > 30) 
            $err = 'Кодовое слово должно содержать не менее 6 символов и не более 30';
        elseif($new != $repeat)
            $err = 'Кодовые слова не совпадают';
        if($err == ''){
            $this->model->replace($this->user->getParam("id"), $new);
            $this->view->addMessBlue('Кодовое слово', 'Кодовое слово изменено');
        }
        else
            $this->view->addMessRed('Ошибка', $err);
    }
    private function main(){
        if(isset($_GET["go"]))
            $this->replace();
        $this->html = '
        <script>
            function passText(){
                window.brouser.openPage("'.$this->game->url.'/html/page/passText.php?go", {"passText_1": $("#passText_1").val(), "passText_2": $("#passText_2").val()}, false);
            }
        </script>
        <div class="p-5-10 center fz20 white">
            <div>
	            <input id="passText_1" type="text" name="newPass" class="form-input w70" placeholder="Кодовое слово" maxlength="32" value="">
	            <input id="passText_2" type="text" name="repeatPass" class="form-input w70" placeholder="Повторите" maxlength="32" value="">
	        </div>
		    <div class="redButton w70 mAuto borderRadius10px p10-0" onclick=passText()>
		        Сменить
		    </div>
		</div>';
    }
    public function setView(){
        $this->main();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}