<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Profil extends \engine\Game{
    private $html = '';
    private $top = 'Профиль';
    private $panel = [
        'Rank', 
        'Sms',
        'Provinces'
    ];
	public function __construct(){
        parent::__construct();
        $this->setAuthorization();
    }
    private function goInvitation(){
        $this->userModel->addInvitation($this->sql["id"], $this->user->getParam("alliance"));
        $this->view->getButtonQuestionBlueOk('Приглашение', 'Приглашение в Союз отправлено', '"window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php?panel=Sms&quot;,{&quot;userId&quot;: &quot;'.$this->sql["id"].'&quot;}, false)"');

    }
    private function setButtonInvitionUnion(){
        $this->modelUnion       = new \model\Union($this);
        $this->position         = $this->modelUnion->getPosition($this->user->getParam("id"), $this->user->getParam("alliance"));
        $this->invitation       = $this->userModel->chackInvitation($this->sql["id"], $this->user->getParam("alliance"));
        if($this->sql["alliance"]==0 and $this->position["invite"]==1 and $this->invitation == null){
            if(isset($_GET["invitation"]))
                $this->goInvitation();
            else
                $this->buttonInvition = '
                <div class="p-5-3 fz20 white center">
        			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php?panel=Sms&invitation&quot;,{&quot;userId&quot;: &quot;'.$this->sql["id"].'&quot;}, false)">
        		        Пригласить в Союз
        		    </div>
                </div>';
        }
    }
    private function getSms(){
        $this->setButtonInvitionUnion();
        $this->top = 'Действия';
        $this->page = '
        <div class="p-5-10 center">
            <div class="p-5-3 fz20 white center">
    			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/mail.php?new&quot;,{&quot;nick&quot;: &quot;'.$this->sql["nick"].'&quot;})">
    		        Новое Сообщение
    		    </div>
            </div>
            '.$this->buttonInvition.'
		</div>';
    }
    private function setButtonUnion(){
        if($this->sql["alliance"]>0){
            $position = $this->sql["union_position"]!=null?$this->sql["union_position"]:'-';
            $url = 'onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/union.php&quot;,{&quot;unionId&quot:'.$this->sql["alliance"].'})"';
            $this->buttonUnion = '
            <div class="p-3-0">
	            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10">
	                <div class="p10">
		                <div class="table w100 blacPanelRedButton borderRadius5px" '.$url.'> 
                			<div class="row">
                				<div class="cell p10 fz20">
                				    Союз: '.$this->sql["union_name"].'
                				</div>
                				<div class="cell fz20 right vam p6">
            					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="30">
            					</div>
                			</div>
                		</div>
                		<div>
    				        Должность: '.$position.'
    				    </div>
            		</div>
	            </div>
            </div>';
        }
        else{
            $this->buttonUnion = '
            <div class="p-3-0 fz20">
                <div class="p-3-0 borderRadius5px alternationNotEven p-5-10">
                    <div class="table w100  borderRadius5px"> 
            			<div class="row">
            				<div class="cell p0-10  vam center left">
            				    <div>
            				        Союз: -
            				    </div>
            				    <div>
            				        Должность: -
            				    </div>
            				</div>
            			</div>
            		</div>
                </div>
            </div>';
        }
        
    }
    private function getRank(){
        $this->setButtonUnion();
        $rank = $this->userModel->getRank($this->sql["id"]);
        $this->xp           = $this->sql["rating"];
        $this->userRank     = $this->rank->getRank($this->xp);
        $this->nextXp       = $this->rank->getXp($this->userRank+1);
        $this->procent      =  $this->rank->getProsent($this->xp, $this->nextXp);
        $this->userRankName = $this->rank->getRankName($this->userRank);
        $this->page = '
        <div class="p-5-10">
            <div class="table w100 tborder10-5"> 
    			<div class="white row">
    				<div class="cell ">
    				    <div class="p6">
    				        <img src="'.$this->url.'/img/rank/'.$this->userRank.'.png" class="vs" height="100">
    					</div>
    				</div>
    				<div class="cell fz20 right vam p6 w100">
    				    <div class="left w100">
    				        <div>
    				            '.$this->sql["nick"].' <span class="green">('.$this->userRankName.')</span>
    				        </div>
    				        <div>
    				            Место: '.$rank.'
    				        </div>
    				    </div>
    				    <div class="fr w100  scaleXpGreen" style="height: 26px;">
                            <div class="rel">
                                <div class="absolute w90 scaleXp" style="height: 26px;width: '.$this->procent.'%;">
                                </div>
                                <div class="absolute center w100">
                                    <img src="'.$this->url.'/img/icons/rating.png" class="vs" height="25">'.$this->xp.'/'.$this->nextXp.'
                                </div>
                            </div>
                        </div>
    				</div>
    			</div>
    		</div>
            '.$this->buttonUnion.'
            <div class="p-3-0">
	            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10">
	                <div class="p10">
		                <div class="table w100 blacPanelRedButton borderRadius5px" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/city.php&quot;,{&quot;cityId&quot;: &quot;'.$this->sql["city_id"].'&quot;})"> 
                			<div class="row">
                				<div class="cell p10 fz20">
                				    Город
                				</div>
                				<div class="cell fz20 right vam p6">
            					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="30">
            					</div>
                			</div>
                		</div>
                		<div>
    				        X:'.$this->sql["x"].' Y:'.$this->sql["y"].'
    				    </div>
            		</div>
	            </div>
            </div>
        </div>';
    }
    private function getProvinces(){
        $count =  $this->sql["invader_col"];
        $this->top = 'Провинции - '.$count;
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->userModel->getProvinces($this->sql["id"], $start);
		if($result->num_rows != 0){
		    while($q = $result->fetch_assoc()){
		        $provinces .= '
                <div class="p-3-0">
    	            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10">
    	                <div class="p10">
    		                <div class="table w100 blacPanelRedButton borderRadius5px" onclick=goCity('.$q["id"].')> 
                    			<div class="row">
                    				<div class="cell p10 fz20">
                    				    <b>'.$q["nick"].'</b> <img src="'.$this->url.'/img/icons/rating.png" class="vs" height="20px">'.$q["rating"].'
                    				</div>
                    				<div class="cell fz20 right vam p6">
                					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="30">
                					</div>
                    			</div>
                    		</div>
                    		<div>
                    		    [X:'.$q["x"].' Y:'.$q["y"].']
        				    </div>
                		</div>
    	            </div>
                </div>';
		    }
		}
		else
		    $provinces = '<div class="center fz20 white">Нет провинций</div>';
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav = '<div class="p-5-10">'.$classPage->str('/html/page/profil.php?panel=Provinces&', $k_page, $page, '{"userId": '.$this->sql["id"].'}').'</div>';   
	    }
	    $this->page = '
        <script>
            function goCity(id){
                window.brouser.openPage("'.$this->url.'/html/page/city.php", {"cityId":id});
            }
        </script>
        <div class="p-5-10">
            '.$provinces.'
            '.$nav.'
        </div>';
    }
    
    private function chackSql(){
        if($this->sql!=null){
            if(isset($_GET["provinces"]))
                $this->showProvinces();
            else
                $this->showProfil();   
        }
        else
            $this->showError();
    }
    private function selectInDb(){
        if(isset($_POST["userId"])){
            $this->userModel = new \model\User($this);
            $this->rank = new \model\Rank($this);
            $this->sql = $this->userModel->getById(intval($_POST["userId"]));
            $this->chackSql();
        }
        else{
            $this->showError();
        }
    }
    private function showError(){
        $this->top = 'Ошибка';
        $this->html = '
        <div class="p-5-10 center fz20">
            Игрок не найден
        </div>';
    }
    private function selectPanel(){
        foreach ($this->panel as $key => $value) {
            if(!isset($_GET["panel"]))
                $_GET["panel"] = 'Rank';
            if($_GET["panel"]==$value){
                $name = 'get'.$value;
                $this->$name();
                $select = true;
            }
            else
                $select = false;
            $url = 'window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php?panel='.$value.'&quot;,{&quot;userId&quot;:'.$this->sql["id"].'}, false)';
            $this->panelButtons .= $this->view->getButtonPanel($url, $this->sql["id"], $value, $select);
        }
    }
    private function showProfil(){
        $this->selectPanel();
        $this->html = '
        <div class="p-5-10">
            <div class=" rel h52px">
                <div class="redPanelTop center w100">
                    <div class="table w100 tborder5-0"> 
            			<div class="row center">
            				'.$this->panelButtons.'
            			</div>
            		</div>
            	</div>
            </div>
            <div class="redPanel redPanelBack p10-0">
                '.$this->page.'
            </div>
        </div>';
    }
    public function setView(){
        $this->selectInDb();
        $this->view->addTop($this->top);
        $this->view->addScript($this->scripts);
        $this->view->setNavigator();
        $this->view->addBody($this->html);
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}