<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Support extends \engine\Game{
    private $html = '';
    private $top  = '';
    
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->model = new \model\Support($this);
        $this->rank = new \model\Rank($this);
        $this->modelNotice = new \model\Notice($this);
    }
    private function addSql(){
        $this->view->addMessBlue('Тикет', 'Добавлен новый тикет');
	    $t = time();
    	$antiSpam = $t + 5;
    	$this->model->addTicket($this->user->getParam("id"), $this->theme, $this->text);
		$query = "UPDATE `users` SET `antispam` = {?} WHERE `id` = {?}";
		$this->db->query($query, [$antiSpam, $this->user->getParam("id")]);
    }
    private function setClosed(){
        $this->model->setClosed($this->sqlTicket["id"], 1);
        $this->sqlTicket["closed"] = 1;
    }
    private function setOpen(){
        $this->model->setClosed($this->sqlTicket["id"], 0);
        $this->sqlTicket["closed"] = 0;
    }
    private function goNewTicket(){
        $this->theme  = htmlspecialchars($_POST["theme"]);
        $this->text   = htmlspecialchars($_POST["text"]);
        $msg    = '';
        
        if(trim($this->theme) != '' && trim($this->text) != ''){
            $this->theme = str_replace(array('r u','ru','RU','R U', 'net','n e t','NET','N E T', 'com', 'COM', 'C O M', 'рф', 'РФ', 'рф', 'tk', 'TK', 'T K','t k', 'esy.es', 'esy . es', 'e s y . e s', 'su', 's u', 'SU', 'S U', 'us', 'US', 'U S', 'u s', 'mobi','m o b i','MOBI','M O B I', 'ua', 'u a', 'U A', 'UA', 'keo.su', 'KEO.SU', 'KEO . SU','k e o . s u', 'K E O . SU', 'K E O.SU', 'worldbyte','WORLDBYTE','world byte','ml', 'ML', 'M L', 'm l', 'ga', 'g a', 'G A', 'GA', 'www','w w w','wap','w a p','h t t p','http'), '*', $this->theme);
            $this->text = str_replace(array('r u','ru','RU','R U', 'net','n e t','NET','N E T', 'com', 'COM', 'C O M', 'рф', 'РФ', 'рф', 'tk', 'TK', 'T K','t k', 'esy.es', 'esy . es', 'e s y . e s', 'su', 's u', 'SU', 'S U', 'us', 'US', 'U S', 'u s', 'mobi','m o b i','MOBI','M O B I', 'ua', 'u a', 'U A', 'UA', 'keo.su', 'KEO.SU', 'KEO . SU','k e o . s u', 'K E O . SU', 'K E O.SU', 'worldbyte','WORLDBYTE','world byte','ml', 'ML', 'M L', 'm l', 'ga', 'g a', 'G A', 'GA', 'www','w w w','wap','w a p','h t t p','http'), '*', $this->text);
            
            if(empty(trim($this->theme))) 
                $msg = 'Тема содержит запрещенные символы';
            elseif(empty(trim($this->text)))
                $msg = 'Текст содержит запрещенные символы';
            elseif(strlen(trim($this->theme)) < 3 || strlen(trim($this->theme)) > 32) 
                $msg = 'Тема должна содержать не менее 3 символов и не более 32';
            elseif(strlen(trim($this->text)) < 3 || strlen(trim($this->text)) > 1024) 
                $msg = 'Текст должен содержать не менее 3 символов и не более 1024';
            else
                $this->addSql();
        }
        else {
            $msg = 'Заполните все поля';
        }
        
		if($msg!='')
	        $this->view->addMessRed("Ошибка", $msg);
    }
    private function checkAntispam(){
        if($this->user->getParam("antispam")<time())
            $this->goNewTicket();
        else
            $this->view->addMessRed("Ошибка", 'Антиспам длиться 5с.');
    }
    private function showNewTicket(){
        if(isset($_POST["theme"]) and isset($_POST["text"]))
            $this->checkAntispam();
        $this->top  = 'Новый тикет';
        $this->html = '
        <script>
            function newTicket(){
                window.brouser.openPage("'.$this->url.'/html/page/support.php?tickets&new", {"theme": $("#theme").val(), "text": $("#text").val()}, false);
            }
        </script>
        <div class="p-5-10 center fz20">
			<div class="p-3-0">Тема:</div>
			<input id="theme" type="text" name="nick" value="'.($this->userRecipient!=null?$this->userRecipient["nick"]:'').'" class="form-input w70">
			<div class="p-3-0">Текст:</div>
			<input id="text" type="text"  name="text" class="form-input w70">
		    <div class="p-3-0">
                <div class="p-5-3 fz20 white center">
        			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick="newTicket()">
        		        Новый тикет
        		    </div>
                </div>
            </div>
		</div>';
    }
    private function getAccessToAdmin(){
        return $this->model->getAccessSupport($this->user->getParam("id"));
    }
    private function showAdmin(){
        $this->top  = 'Админка';
        $this->ticketsText = '';
        $count = $this->model->countAdminTickets();
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
        $result = $this->model->getAdminTickets($start);
        if($result->num_rows>0){
            while($q = $result->fetch_assoc()){
                if($q["closed"]==0)
                    $this->ticketsText .= $this->view->showViewButton(["name" => $q["theme"], "icon" => "/img/icons/support.png",  "url" => "/html/page/support.php?admin&ticketId=$q[id]"]);
                else
                    $this->ticketsText .= $this->view->showViewButtonOff(["name" => $q["theme"], "icon" => "/img/icons/support.png",  "url" => "/html/page/support.php?admin&ticketId=$q[id]"]);
            }
            if($count >= 11){
    	        $classPage = new \engine\Page();
    	        $this->ticketsText .= '<hr><div class="p-5-10">'.$classPage->str('/html/page/support.php?admin&', $k_page, $page).'</div>';   
    	    }
        }
        else{
            $this->ticketsText = '
            <div class="p-5-10 center">
                Нет тикетов
            </div>';
        }
        $this->html = $this->ticketsText;
    }
    private function showTickets(){
        $this->top  = 'Тикеты';
        $this->getTickets();
        $this->html = '
        <div class="p-3-0">
            <div class="p-5-3 fz20 white center">
    			<div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->getUrl().'/html/page/support.php?tickets&new&quot;,{})">
    		        Новый тикет
    		    </div>
            </div>
        </div>'.
        '<hr>'.
        $this->ticketsText;
    }
    private function getTickets(){
        $this->ticketsText = '';
        $count = $this->model->countTickets($this->user->getParam("id"));
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
        $result = $this->model->getTickets($this->user->getParam("id"), $start);
        if($result->num_rows>0){
            while($q = $result->fetch_assoc()){
                if($q["closed"]==0)
                    $this->ticketsText .= $this->view->showViewButton(["name" => $q["theme"], "icon" => "/img/icons/support.png",  "url" => "/html/page/support.php?tickets&ticketId=$q[id]"]);
                else
                    $this->ticketsText .= $this->view->showViewButtonOff(["name" => $q["theme"], "icon" => "/img/icons/support.png",  "url" => "/html/page/support.php?tickets&ticketId=$q[id]"]);
            }
            if($count >= 11){
    	        $classPage = new \engine\Page();
    	        $this->ticketsText .= '<hr><div class="p-5-10">'.$classPage->str('/html/page/support.php?tickets&', $k_page, $page).'</div>';   
    	    }
        }
        else{
            $this->ticketsText = '
            <div class="p-5-10 center">
                У вас нет тикетов
            </div>';
        }
    }
    private function showAdmins(){
        $this->top  = 'Администрация';
        $result = $this->model->getSupport();
        while($q = $result->fetch_assoc()){
            $rank = $this->rank->getRank($q["rating"]);
		        $support .= '
		        <div class="p-3-0">
    	            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10" onclick="window.brouser.openPage(&quot;'.$this->getUrl().'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$q["user"].'})">
    	                <div class="p10">
    		                <div class="table w100 blacPanelRedButton borderRadius5px" '.$url.'> 
                    			<div class="row">
                    				<div class="cell p10 fz20">
                    				    <img src="'.$this->getUrl().'/img/rank/'.$rank.'.png" class="vs" height="30">
            				            '.$q["nick"].'
                    				</div>
                    				<div class="cell fz20 right vam p6">
                					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="30">
                					</div>
                    			</div>
                    		</div>
                    		<div>
        				        '.$q["name"].'
        				    </div>
                		</div>
    	            </div>
                </div>';
        }
        $this->html = '
        <div class="p-5-10">
            <div class="redPanel redPanelBack p-5-10">
                '.$support.'
            </div>
        </div>';
    }
    private function showIndex(){
        $this->top  = 'Служба поддержки';
        if($this->getAccessToAdmin()!= null)
            $admin = $this->view->showViewButton(["url"=>'/html/page/support.php?admin', "name"=>"Админка", "icon"=>"img/icons/contacts.png"]);
        $this->html = '
        <div class="p-5-10">
            '.$this->view->showViewButton(["url"=>'/html/page/support.php?tickets', "name"=>"Тикеты", "icon"=>"img/icons/sms.png"]).'
            '.$admin.'
            '.$this->view->showViewButton(["url"=>'/html/page/support.php?admins', "name"=>"Администрация", "icon"=>"img/icons/contacts.png"]).'
        </div>';
    }
    private function showTicketAdminId(){
        $this->top = $this->sqlTicket["theme"];
        if(isset($_GET["closed"]))
            $this->setClosed();
        elseif(isset($_GET["open"]))
            $this->setOpen();
        $status = '<span class="green textUnder" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/support.php?admin&ticketId='.$this->sqlTicket["id"].'&closed&quot;,{}, false)">Открыто</span>';
        if($this->sqlTicket["closed"]>0)
            $status = '<span class="textUnder" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/support.php?admin&ticketId='.$this->sqlTicket["id"].'&open&quot;,{}, false)">Закрыто</span>';
        if(isset($_POST["text"]))
            $this->addAdminMsg();
        $count = $this->model->getCountComments($this->sqlTicket["id"]);
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->model->getComments($this->sqlTicket["id"], $start);
        if($result->num_rows != 0){
		    while($q = $result->fetch_assoc()){
		        $rank = $this->rank->getRank($q["rating"]);
		        $comments .= '
		        <div class="p-3-0">
		            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10">
		                <div class="p10">
    		                <div class="table w100 blacPanelRedButton borderRadius5px" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$q["user"].'}, false)"> 
                    			<div class="row">
                    				<div class="cell p10 fz20">
                        				    '.$q["nick"].' ['.$this->timer->tl(time()-$q["timer"]).']
                    				</div>
                    				<div class="cell fz20 right vam p6">
                					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="30">
                					</div>
                    			</div>
                    		</div>
                		</div>
                		<div class="p0-10 fz20">
        				    '.$q["msg"].'
        				</div>
		            </div>
	            </div>';
		    }
        }
        else{
            $comments = '<div class="p-5-10 white fz20 center">Нет комментариев</div>';  
        }
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav = '<div class="p-5-10">'.$classPage->str('/html/page/support.php?admin&ticketId='.$this->sqlTicket["id"].'&', $k_page, $page, '{}').'</div>';   
	    }
        $this->html = '
        <div class="p-5-10">
            <div class="redPanel redPanelBack p10-0">
                <div class="p-5-10 left fz20 white">
                    <div>
                        Автор: <span class="textUnder" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$this->sqlTicket["user"].'}, false)">'.$this->sqlTicket["nick"].'</span>
                    </div>
                    <div>
                        Статус: '.$status.'
                    </div>
                    <div>
                        Описание: '.$this->sqlTicket["msg"].'
                    </div>
                </div>
                <div class="hrRed">
			    </div>
			    <div class="p-5-10 blacPanelRedButton white center fz20">
                    Комментарии - '.$count.'
			    </div>
			    <div class="hrRed">
			    </div>
			    <div class="center">
                    <div class="p-5-3 fz20 white center">
            		    <input id="text" type="text" maxlength="1024" name="text" value="" class="form-inputPanelRed w70 left p-3-0">
                    </div>
                    <div class="p-5-3 fz20 white center">
                        <div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/support.php?admin&ticketId='.$this->sqlTicket["id"].'&quot;,{&quot;text&quot;: $(&quot;#text&quot;).val()}, false)">
            		        Написать
            		    </div>
            		</div>
                </div>
                <div class="p-5-10 left">
                    '.$comments.'
                </div>
                <div class="center">
                    '.$nav.'
                </div>
            </div>
        </div>';
    }
    private function checkTicketAdminId(){
        $ticketId = intval($_GET["ticketId"]);
        $this->sqlTicket = $this->model->getTicketAdminId($ticketId);
        if($this->sqlTicket!=null)
            $this->showTicketAdminId();
        else
            $this->showTicketError();
    }
    private function routerIndex(){
        if(isset($_GET["admins"]))
            $this->showAdmins();
        elseif(isset($_GET["admin"])){
            if($this->getAccessToAdmin()!=null){
                if(isset($_GET["ticketId"]))
                    $this->checkTicketAdminId();
                else
                    $this->showAdmin();   
            }
        }
        elseif(isset($_GET["tickets"])){
            if(isset($_GET["ticketId"]))
                $this->checkTicketId();
            elseif(isset($_GET["new"]))
                $this->showNewTicket();
            else
                $this->showTickets();
        }
        else
            $this->showIndex();
    }
    private function checkTicketId(){
        $ticketId = intval($_GET["ticketId"]);
        $this->sqlTicket = $this->model->getTicketId($this->user->getParam("id"), $ticketId);
        if($this->sqlTicket!=null)
            $this->showTicketId();
        else
            $this->showTicketError();
    }
    private function showTicketError(){
        $this->top  = 'Ошибка';
        $this->html = '<div class="p-5-10 fz20 center">Тикет не найден</div>';
    }
    
    private function addAdminMsg(){
        $text = $_POST["text"];
        $msg = '';
        
        if(trim($text) != ''){
            $text = str_replace(array('r u','ru','RU','R U', 'net','n e t','NET','N E T', 'com', 'COM', 'C O M', 'рф', 'РФ', 'рф', 'tk', 'TK', 'T K','t k', 'esy.es', 'esy . es', 'e s y . e s', 'su', 's u', 'SU', 'S U', 'us', 'US', 'U S', 'u s', 'mobi','m o b i','MOBI','M O B I', 'ua', 'u a', 'U A', 'UA', 'keo.su', 'KEO.SU', 'KEO . SU','k e o . s u', 'K E O . SU', 'K E O.SU', 'worldbyte','WORLDBYTE','world byte','ml', 'ML', 'M L', 'm l', 'ga', 'g a', 'G A', 'GA', 'www','w w w','wap','w a p','h t t p','http'), '*', $text);
            
            if(empty(trim($text))) 
                $msg = 'Сообщение содержит запрещенные символы';
            elseif(strlen(trim($text)) < 2 || strlen(trim($text)) >= 1000)
                $this->view->addMessRed('Ошибка', 'Комментарий должен содержать не менее 2 символов и не более 1000');
            else {
                $this->model->addComment($this->user->getParam("id"), $this->sqlTicket["id"], $text);
                
                $tema = 'Ответ на тикет';
                $text = '
                <div class="p-5-10">
                    <div>
                        Вам ответили на ваш вопрос в <span class="textUnder" onclick="window.brouser.openPage(&quot;'.$this->getUrl().'/html/page/support.php?tickets&ticketId='.$this->sqlTicket["id"].'&quot;,{})">тикете</span>.
                    </div>
                    <div>
                        Ответ: '.$text.'
                    </div>
                </div>';
                $this->modelNotice->create( $this->sqlTicket["user"], $tema, $text);
            }
        }
        else {
            $this->view->addMessRed('Ошибка', 'Введите сообщение');
        }
    }
    
    private function addMsg(){
        $text = $_POST["text"];
        $msg = '';
        
        if(trim($text) != ''){
            $text = str_replace(array('r u','ru','RU','R U', 'net','n e t','NET','N E T', 'com', 'COM', 'C O M', 'рф', 'РФ', 'рф', 'tk', 'TK', 'T K','t k', 'esy.es', 'esy . es', 'e s y . e s', 'su', 's u', 'SU', 'S U', 'us', 'US', 'U S', 'u s', 'mobi','m o b i','MOBI','M O B I', 'ua', 'u a', 'U A', 'UA', 'keo.su', 'KEO.SU', 'KEO . SU','k e o . s u', 'K E O . SU', 'K E O.SU', 'worldbyte','WORLDBYTE','world byte','ml', 'ML', 'M L', 'm l', 'ga', 'g a', 'G A', 'GA', 'www','w w w','wap','w a p','h t t p','http'), '*', $text);
            
            if(empty(trim($text))) 
                $msg = 'Сообщение содержит запрещенные символы';
            elseif(strlen(trim($text)) < 2 || strlen(trim($text)) >= 1000)
                $msg = 'Комментарий должен содержать не менее 2 символов и не более 1000';
            else
                $this->model->addComment($this->user->getParam("id"), $this->sqlTicket["id"], $text);
        }
        else {
            $msg = 'Введите сообщение';
        }
        
        if($msg != '')
            $this->view->addMessRed('Ошибка', $msg);
    }
    
    private function showTicketId(){
        $this->top = $this->sqlTicket["theme"];
        if(isset($_GET["closed"]))
            $this->setClosed();
        $status = '<span class="green textUnder" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/support.php?tickets&ticketId='.$this->sqlTicket["id"].'&closed&quot;,{}, false)">Открыто</span>';
        if($this->sqlTicket["closed"]>0)
            $status = 'Закрыто';
        if(isset($_POST["text"]))
            $this->addMsg();
        $count = $this->model->getCountComments($this->sqlTicket["id"]);
        $k_page = \engine\Page::k_page($count, 10);
		$page = \engine\Page::page($k_page);
		$start = 10 * $page - 10;
		$result = $this->model->getComments($this->sqlTicket["id"], $start);
        if($result->num_rows != 0){
		    while($q = $result->fetch_assoc()){
		        $rank = $this->rank->getRank($q["rating"]);
		        $comments .= '
		        <div class="p-3-0">
		            <div class="p-3-0 borderRadius5px alternationNotEven p-5-10">
		                <div class="p10">
    		                <div class="table w100 blacPanelRedButton borderRadius5px" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/profil.php&quot;,{&quot;userId&quot;: '.$q["user"].'}, false)"> 
                    			<div class="row">
                    				<div class="cell p10 fz20">
                        				'.$q["nick"].' ['.$this->timer->tl(time()-$q["timer"]).']
                    				</div>
                    				<div class="cell fz20 right vam p6">
                					    <img src="'.$this->url.'/img/icons/back.png" class="vs" height="30">
                					</div>
                    			</div>
                    		</div>
                		</div>
                		<div class="p0-10 fz20">
        				    '.$q["msg"].'
        				</div>
		            </div>
	            </div>';
		    }
        }
        else{
            $comments = '<div class="p-5-10 white fz20 center">Нет комментариев</div>';  
        }
        if($count >= 11){
	        $classPage = new \engine\Page();
	        $nav = '<div class="p-5-10">'.$classPage->str('/html/page/support.php?tickets&ticketId='.$this->sqlTicket["id"].'&', $k_page, $page, '{}').'</div>';   
	    }
        $this->html = '
        <div class="p-5-10">
            <div class="redPanel redPanelBack p10-0">
                <div class="p-5-10 left fz20 white">
                    <div>
                        Статус: '.$status.'
                    </div>
                    <div>
                        Описание: '.$this->sqlTicket["msg"].'
                    </div>
                </div>
                <div class="hrRed">
			    </div>
			    <div class="p-5-10 blacPanelRedButton white center fz20">
                    Комментарии - '.$count.'
			    </div>
			    <div class="hrRed">
			    </div>
			    <div class="center">
                    <div class="p-5-3 fz20 white center">
            		    <input id="text" type="text" maxlength="1024" name="text" value="" class="form-inputPanelRed w70 left p-3-0">
                    </div>
                    <div class="p-5-3 fz20 white center">
                        <div class="redButton w70 mAuto borderRadius10px p10-0" onclick="window.brouser.openPage(&quot;'.$this->url.'/html/page/support.php?tickets&ticketId='.$this->sqlTicket["id"].'&quot;,{&quot;text&quot;: $(&quot;#text&quot;).val()}, false)">
            		        Написать
            		    </div>
            		</div>
                </div>
                <div class="p-5-10 left">
                    '.$comments.'
                </div>
                <div class="center">
                    '.$nav.'
                </div>
            </div>
        </div>';
    }
    public function setView(){
        $this->routerIndex();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}