<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class Union extends \engine\Game{
    private $html = '';
    private $top  = '';
    private $panel = [
        'Union', 
        'Position',
        'Rank',
        'Statute',
        'Notice'
    ];
    private $ally = ['Notice'];
    public function __construct(){
        parent::__construct();
        $this->setAuthorization();
        $this->userModel = new \model\User($this);
        $this->rank = new \model\Rank($this);
        $this->model = new \model\Union($this);
    }
    private function closeAccess(){
        foreach ($this->panel as $key => $value) {
            foreach ($this->ally as $keyAlly => $valueAlly) {
                if($value == $valueAlly)
                     unset($this->panel[$key]);
            }
        }
    }
    private function selectPanel(){
        if($this->user->getParam('alliance')!=$this->sql["id"])
            $this->closeAccess();
        foreach ($this->panel as $key => $value) {
            if(!isset($_GET["panel"]))
                $_GET["panel"] = 'Union';
            if($_GET["panel"]==$value){
                $name = '\\addPage\\union\\'.$value;
                $str = new $name($this);
                $this->top  = $str->top;
                $this->page  = $str->html;
                $select = true;
            }
            else
                $select = false;
            $this->panelButtons .= $this->model->getButtonPanel($this->sql["id"], $value, $select);
        }
    }
    private function show(){
        $this->selectPanel();
        $this->html = '
        <div class="p-5-10">
            <div class=" rel h52px">
                <div class="redPanelTop center w100">
                    <div class="table w100 tborder5-0"> 
            			<div class="row center">
            				'.$this->panelButtons.'
            			</div>
            		</div>
            	</div>
            </div>
            <div class="redPanel redPanelBack p10-0">
                '.$this->page.'
            </div>
        </div>';
    }
    private function showChat(){
        $this->chat = new \addPage\union\Chat($this);
        $this->top  = $this->chat->top;
        $this->html  = $this->chat->html;
    }
    private function showRaid(){
        $this->raid = new \addPage\union\Raid($this);
        $this->top  = $this->raid->top;
        $this->html  = $this->raid->html;
    }
    private function showNews(){
        $this->news = new \addPage\union\News($this);
        $this->top  = $this->news->top;
        $this->html  = $this->news->html;
    }
    private function controlRouter(){
        $this->control = new \addPage\union\Control($this);
        $this->top  = $this->control->top;
        $this->html  = $this->control->html;
    }
    private function start(){
        if(isset($_GET["control"]) and $this->user->getParam('alliance')==$this->sql["id"])
            $this->controlRouter();
        elseif(isset($_GET["toAppoint"]) and $this->user->getParam('alliance')==$this->sql["id"])
            $this->showChat();
        elseif(isset($_GET["chat"]) and $this->user->getParam('alliance')==$this->sql["id"])
            $this->showChat();
        elseif(isset($_GET["news"]) and $this->user->getParam('alliance')==$this->sql["id"])
            $this->showNews();
        elseif(isset($_GET["raid"]) and $this->user->getParam('alliance')==$this->sql["id"])
            $this->showRaid();
        else
            $this->show();
    }
    private function showError(){
        $this->top = 'Ошибка';
        $this->html = '
        <div class="p-5-10 center fz20">
            Союз не найден
        </div>';
    }
    private function chackSql(){
        if($this->sql!= null)
            $this->start();
        else
            $this->showError();
    }
    private function selectInDb(){
        if(isset($_POST["unionId"])){
            $this->sql = $this->model->getById(intval($_POST["unionId"]));
            $this->chackSql();
        }
        else{
            $this->showError();
        }
    }
    public function setView(){
        $this->model = new \model\Union($this);
        $this->selectInDb();
        $this->view->addTop($this->top);
        $this->view->addBody($this->html);
        $this->view->setNavigator();
        $this->view->setType('html');
        $this->view->echoEver(); 
    }
}