<?php
namespace page;
$root = $_SERVER['DOCUMENT_ROOT'];
include_once ($root.'/class/engine/game.php');
class WorldKassa extends \engine\Game{
    private $html = '';
    public function __construct(){
        parent::__construct();
        $this->model = new \model\WorldKassa($this);
        $this->modelMarket = new \model\Market($this);
    }
    public function setViewError(){
        $test =  '<script>
                window.brouser.openPage("'.$this->url.'/html/page/market.php?cristal", {}, false);
		    
		    </script>';
        $this->html = $test;
    }
    public function setViewResult(){

        $mode = null;
        if (!empty($_POST['label'])) {
            $mode = 'yoomoney';
        } else if (!empty($_POST['m_orderid'])) {
            $mode = 'payeer';
        }

        switch ($mode) {

            case 'yoomoney':
                $amount = $_POST['withdraw_amount'] ?? 0;

                $notification_type = $_POST['notification_type'] ?? '';
                $operation_id = $_POST['operation_id'] ?? '';
                $amount_hash = $_POST['amount'] ?? 0;
                $currency = $_POST['currency'] ?? '';
                $datetime = $_POST['datetime'] ?? '';
                $sender = $_POST['sender'] ?? '';
                $codepro = $_POST['codepro'] ?? '';
                $order_id = $_POST['label'] ?? '';
                $sha1_hash = $_POST['sha1_hash'] ?? '';
                $notification_secret = $this->model->keyYoo;

                $hash_string = implode('&', [
                    $notification_type,
                    $operation_id,
                    $amount_hash,
                    $currency,
                    $datetime,
                    $sender,
                    $codepro,
                    $notification_secret,
                    $order_id
                ]);

                $expected_hash = sha1($hash_string);

                file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/yoo.txt', print_r($_REQUEST, true) . PHP_EOL, FILE_APPEND);

                if (!hash_equals($expected_hash, $sha1_hash)) {
                    http_response_code(400);
                    die('Ошибка проверки подлинности уведомления');
                }

                break;
            case 'payeer':

                $order_id = $_POST['m_orderid'] ?? '';
                $amount = $_POST['m_amount'] ?? '';

                $arHash = [
                    $_POST['m_operation_id'] ?? '',
                    $_POST['m_operation_ps'] ?? '',
                    $_POST['m_operation_date'] ?? '',
                    $_POST['m_operation_pay_date'] ?? '',
                    $_POST['m_shop'] ?? '',
                    $order_id,
                    $amount,
                    $_POST['m_curr'] ?? '',
                    $_POST['m_desc'] ?? '',
                    $_POST['m_status'] ?? '',
                    $this->model->keyShopPayeer ?? ''
                ];

                $sign_hash = strtoupper(hash('sha256', implode(':', $arHash)));

                file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/payeer.txt', print_r($_REQUEST, true) . PHP_EOL, FILE_APPEND);

                $m_sign = !empty($_POST['m_sign']) ? $_POST['m_sign'] : '';

                if (!hash_equals($sign_hash, $m_sign)) {
                    die($order_id . '|error');
                }
                break;
            default:
                http_response_code(404);
        }

        if (!empty($order_id)) {

            $getOrderId = $this->model->select($order_id);

            if (empty($getOrderId)) {
                http_response_code(400);
                die('Заказ не найден в системе');
            }

            if (!empty($getOrderId) && $getOrderId['status'] == 0) {
                $this->model->updatePay($getOrderId["id"]);
                $this->modelMarket->plassCristal($getOrderId["user"], $getOrderId["price"]);
            }


            http_response_code(200);

            // если payeer, возвращаем ответ
            // https://payeer.com/ru/account/api/
            if (!empty($mode) && $mode == 'payeer' && $_POST['m_status'] == 'success') {
                die($order_id . '|success');
            }

            die('OK');
        }
        http_response_code(400);



        die;
    }
    public function setViewSuccess(){
        
        $this->html = '
        
        <script>
            function setCookie(name, value, days){
        	  if (days)
        	  {
        		var date = new Date();
        		date.setTime(date.getTime()+days*24*60*60*1000); // ) removed
        		var expires = "; expires=" + date.toGMTString(); // + added
        	  }
        	  else
        		var expires = "";
        	  document.cookie = name + "=" + value + expires + ";path=/";
        	}
            setCookie("worldkassa", true, 1);
            window.close();
        </script>';
    }
    public function setView(){
        echo $this->html;
    }
}