// Переключение темы
function toggleTheme() {
    const currentTheme = document.documentElement.getAttribute('data-theme');
    const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
    
    document.documentElement.setAttribute('data-theme', newTheme);
    document.cookie = `theme=${newTheme}; path=/; max-age=${60*60*24*365}`;
    
    // Загружаем CSS темы динамически
    loadThemeCSS(newTheme);
}

function loadThemeCSS(theme) {
    let link = document.getElementById('theme-css');
    if (!link) {
        link = document.createElement('link');
        link.id = 'theme-css';
        link.rel = 'stylesheet';
        document.head.appendChild(link);
    }
    link.href = `assets/css/${theme}-theme.css`;
}

// Инициализация темы при загрузке
document.addEventListener('DOMContentLoaded', function() {
    const savedTheme = getCookie('theme') || 'light';
    document.documentElement.setAttribute('data-theme', savedTheme);
    loadThemeCSS(savedTheme);
    
    // AJAX добавление в корзину
    document.querySelectorAll('.add-to-cart').forEach(button => {
        button.addEventListener('click', function(e) {
            e.preventDefault();
            const productId = this.dataset.productId;
            
            fetch('/api/cart.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ product_id: productId, action: 'add' })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showNotification('Товар добавлен в корзину!', 'success');
                    updateCartCount(data.cart_count);
                } else {
                    showNotification(data.error, 'error');
                }
            });
        });
    });
});

// Вспомогательные функции
function getCookie(name) {
    const value = `; ${document.cookie}`;
    const parts = value.split(`; ${name}=`);
    if (parts.length === 2) return parts.pop().split(';').shift();
}

function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type} fixed-top mt-5 mx-auto`;
    notification.style.cssText = 'max-width: 300px; z-index: 9999;';
    notification.textContent = message;
    
    document.body.appendChild(notification);
    
    setTimeout(() => {
        notification.remove();
    }, 3000);
}

function updateCartCount(count) {
    const cartCount = document.getElementById('cart-count');
    if (cartCount) {
        cartCount.textContent = count;
    }
}