<?php
require_once 'includes/config.php';
require_once 'includes/functions.php';

$title = "Контакты - свяжитесь с нами";
$theme = isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light';

include 'templates/header.php';
?>

<div class="container py-5">
    <!-- Заголовок -->
    <div class="row mb-5">
        <div class="col-12">
            <h1 class="display-5 mb-3">
                <i class="fas fa-headset text-primary me-2"></i>Контакты
            </h1>
            <p class="lead text-muted">
                Свяжитесь с нами любым удобным способом. Мы всегда готовы помочь вам с выбором товара, 
                решением технических вопросов или консультацией по покупке.
            </p>
        </div>
    </div>
    
    <!-- Контактная информация -->
    <div class="row mb-5">
        <div class="col-lg-4 mb-4">
            <div class="card h-100 border-primary text-center">
                <div class="card-body">
                    <div class="contact-icon mb-4">
                        <i class="fas fa-envelope fa-4x text-primary"></i>
                    </div>
                    <h4 class="card-title">Электронная почта</h4>
                    <p class="card-text text-muted">
                        Основной канал связи для всех вопросов
                    </p>
                    <div class="contact-info">
                        <a href="mailto:support@<?php echo parse_url(SITE_URL, PHP_URL_HOST); ?>" 
                           class="btn btn-outline-primary">
                            <i class="fas fa-paper-plane me-2"></i>
                            support@<?php echo parse_url(SITE_URL, PHP_URL_HOST); ?>
                        </a>
                    </div>
                    <div class="mt-3 small text-muted">
                        <i class="fas fa-clock me-1"></i>
                        Ответ в течение 24 часов
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4 mb-4">
            <div class="card h-100 border-success text-center">
                <div class="card-body">
                    <div class="contact-icon mb-4">
                        <i class="fas fa-comments fa-4x text-success"></i>
                    </div>
                    <h4 class="card-title">Онлайн-чат</h4>
                    <p class="card-text text-muted">
                        Быстрая помощь в реальном времени
                    </p>
                    <div class="contact-info">
                        <button class="btn btn-outline-success" id="openChatBtn">
                            <i class="fas fa-comment-dots me-2"></i>
                            Открыть чат
                        </button>
                    </div>
                    <div class="mt-3 small text-muted">
                        <i class="fas fa-user-clock me-1"></i>
                        Работает 24/7
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4 mb-4">
            <div class="card h-100 border-info text-center">
                <div class="card-body">
                    <div class="contact-icon mb-4">
                        <i class="fas fa-phone-alt fa-4x text-info"></i>
                    </div>
                    <h4 class="card-title">Телефон</h4>
                    <p class="card-text text-muted">
                        Для срочных вопросов и консультаций
                    </p>
                    <div class="contact-info">
                        <a href="tel:+78001234567" class="btn btn-outline-info">
                            <i class="fas fa-phone me-2"></i>
                            8 (800) 123-45-67
                        </a>
                    </div>
                    <div class="mt-3 small text-muted">
                        <i class="fas fa-phone-volume me-1"></i>
                        Бесплатный звонок по России
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Форма обратной связи -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-paper-plane me-2"></i>Форма обратной связи
                    </h5>
                </div>
                <div class="card-body">
                    <form id="contactForm">
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="contactName" class="form-label">Ваше имя *</label>
                                <input type="text" class="form-control" id="contactName" required>
                            </div>
                            
                            <div class="col-md-6 mb-3">
                                <label for="contactEmail" class="form-label">Email для ответа *</label>
                                <input type="email" class="form-control" id="contactEmail" required>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label for="contactSubject" class="form-label">Тема сообщения *</label>
                            <select class="form-select" id="contactSubject" required>
                                <option value="">Выберите тему</option>
                                <option value="general">Общий вопрос</option>
                                <option value="technical">Техническая проблема</option>
                                <option value="payment">Вопрос об оплате</option>
                                <option value="refund">Возврат средств</option>
                                <option value="partnership">Сотрудничество</option>
                                <option value="other">Другое</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label for="contactMessage" class="form-label">Ваше сообщение *</label>
                            <textarea class="form-control" id="contactMessage" rows="5" required
                                      placeholder="Опишите подробно ваш вопрос или проблему..."></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label for="orderNumber" class="form-label">Номер заказа (если есть)</label>
                            <input type="text" class="form-control" id="orderNumber" 
                                   placeholder="ORD-2023-XXXXX">
                        </div>
                        
                        <div class="mb-3">
                            <label for="fileAttachment" class="form-label">Прикрепить файл (до 10MB)</label>
                            <input type="file" class="form-control" id="fileAttachment" 
                                   accept=".jpg,.jpeg,.png,.pdf,.doc,.docx,.zip,.rar">
                            <div class="form-text">
                                Можно прикрепить скриншоты, документы или другие файлы
                            </div>
                        </div>
                        
                        <div class="form-check mb-4">
                            <input type="checkbox" class="form-check-input" id="subscribeNewsletter" checked>
                            <label class="form-check-label" for="subscribeNewsletter">
                                Подписаться на новости и акции магазина
                            </label>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="fas fa-paper-plane me-2"></i>Отправить сообщение
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Дополнительные способы связи -->
    <div class="row mb-5">
        <div class="col-12">
            <h3 class="mb-4">Другие способы связи</h3>
            
            <div class="row">
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">
                                <i class="fab fa-telegram text-primary me-2"></i>Telegram
                            </h5>
                            <p class="card-text text-muted">
                                Быстрые ответы в мессенджере. Подпишитесь на наш канал для новостей.
                            </p>
                            <div class="d-flex gap-2">
                                <a href="https://t.me/<?php echo SITE_NAME; ?>" 
                                   class="btn btn-outline-primary" 
                                   target="_blank">
                                    <i class="fab fa-telegram me-2"></i>Канал новостей
                                </a>
                                <a href="https://t.me/support_<?php echo strtolower(str_replace(' ', '_', SITE_NAME)); ?>" 
                                   class="btn btn-outline-secondary" 
                                   target="_blank">
                                    <i class="fas fa-comment me-2"></i>Чат поддержки
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">
                                <i class="fab fa-vk text-primary me-2"></i>ВКонтакте
                            </h5>
                            <p class="card-text text-muted">
                                Следите за нами в социальной сети. Анонсы, конкурсы и полезный контент.
                            </p>
                            <a href="https://vk.com/<?php echo strtolower(str_replace(' ', '', SITE_NAME)); ?>" 
                               class="btn btn-outline-primary" 
                               target="_blank">
                                <i class="fab fa-vk me-2"></i>Перейти в группу
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">
                                <i class="fab fa-github me-2"></i>GitHub
                            </h5>
                            <p class="card-text text-muted">
                                Открытые проекты и баг-репорты. Для технических вопросов и разработчиков.
                            </p>
                            <a href="https://github.com/<?php echo strtolower(str_replace(' ', '-', SITE_NAME)); ?>" 
                               class="btn btn-outline-dark" 
                               target="_blank">
                                <i class="fab fa-github me-2"></i>Перейти на GitHub
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-4">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title">
                                <i class="fas fa-map-marker-alt text-danger me-2"></i>Юридический адрес
                            </h5>
                            <p class="card-text text-muted">
                                Для официальных писем и документов
                            </p>
                            <address class="mb-0">
                                <strong><?php echo SITE_NAME; ?></strong><br>
                                123456, г. Москва, ул. Примерная, д. 1<br>
                                ОГРН: 1234567890123<br>
                                ИНН: 1234567890
                            </address>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Часто задаваемые вопросы -->
    <div class="row mb-5">
        <div class="col-12">
            <h3 class="mb-4">Прежде чем написать...</h3>
            
            <div class="card">
                <div class="card-body">
                    <p class="card-text mb-4">
                        Возможно, ответ на ваш вопрос уже есть в наших часто задаваемых вопросах. 
                        Это поможет сэкономить ваше и наше время.
                    </p>
                    
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <div class="list-group">
                                <a href="/faq.php#buying" class="list-group-item list-group-item-action">
                                    <i class="fas fa-shopping-cart me-2"></i>Вопросы о покупке
                                </a>
                                <a href="/faq.php#download" class="list-group-item list-group-item-action">
                                    <i class="fas fa-download me-2"></i>Скачивание товаров
                                </a>
                                <a href="/faq.php#payment" class="list-group-item list-group-item-action">
                                    <i class="fas fa-credit-card me-2"></i>Оплата и счета
                                </a>
                            </div>
                        </div>
                        
                        <div class="col-md-4 mb-3">
                            <div class="list-group">
                                <a href="/faq.php#account" class="list-group-item list-group-item-action">
                                    <i class="fas fa-user me-2"></i>Аккаунт и профиль
                                </a>
                                <a href="/faq.php#technical" class="list-group-item list-group-item-action">
                                    <i class="fas fa-cog me-2"></i>Технические вопросы
                                </a>
                                <a href="/faq.php#refund" class="list-group-item list-group-item-action">
                                    <i class="fas fa-undo me-2"></i>Возврат и гарантия
                                </a>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="alert alert-info">
                                <h6><i class="fas fa-lightbulb me-2"></i>Быстрые ответы</h6>
                                <p class="small mb-2"><strong>Вопрос:</strong> Как быстро вы отвечаете?</p>
                                <p class="small mb-3"><strong>Ответ:</strong> В течение 24 часов в рабочее время</p>
                                
                                <p class="small mb-2"><strong>Вопрос:</strong> Есть ли телефон горячей линии?</p>
                                <p class="small mb-0"><strong>Ответ:</strong> Да, 8 (800) 123-45-67 (бесплатно)</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <a href="/faq.php" class="btn btn-outline-primary">
                            <i class="fas fa-question-circle me-2"></i>Перейти ко всем вопросам
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Карта и время работы -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title mb-4">
                        <i class="fas fa-clock me-2"></i>Время работы поддержки
                    </h5>
                    
                    <div class="row">
                        <div class="col-md-6 mb-4">
                            <div class="schedule">
                                <div class="schedule-item">
                                    <span class="day">Понедельник - Пятница</span>
                                    <span class="time">09:00 - 21:00</span>
                                </div>
                                <div class="schedule-item">
                                    <span class="day">Суббота</span>
                                    <span class="time">10:00 - 18:00</span>
                                </div>
                                <div class="schedule-item">
                                    <span class="day">Воскресенье</span>
                                    <span class="time">12:00 - 16:00</span>
                                </div>
                                <div class="schedule-item holiday">
                                    <span class="day">Праздничные дни</span>
                                    <span class="time">10:00 - 16:00</span>
                                </div>
                            </div>
                            
                            <div class="mt-4">
                                <h6><i class="fas fa-globe me-2"></i>Часовой пояс</h6>
                                <p class="text-muted small mb-0">
                                    Время указано по Московскому времени (GMT+3)
                                </p>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <!-- Простая карта -->
                            <div class="map-placeholder bg-light rounded d-flex align-items-center justify-content-center" 
                                 style="height: 200px;">
                                <div class="text-center">
                                    <i class="fas fa-map-marker-alt fa-3x text-danger mb-3"></i>
                                    <p class="mb-0 text-muted">Москва, Россия</p>
                                </div>
                            </div>
                            
                            <div class="mt-3">
                                <h6><i class="fas fa-shield-alt me-2"></i>Безопасность связи</h6>
                                <p class="text-muted small mb-0">
                                    Все сообщения защищены SSL-шифрованием. Мы никогда не просим 
                                    пароли от ваших аккаунтов или данные банковских карт.
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Чат поддержки (скрытый по умолчанию) -->
<div class="chat-container" id="chatContainer" style="display: none;">
    <div class="chat-header">
        <h6 class="mb-0">
            <i class="fas fa-headset me-2"></i>Чат поддержки
        </h6>
        <button class="btn-close btn-close-white" id="closeChatBtn"></button>
    </div>
    <div class="chat-body" id="chatBody">
        <div class="chat-message bot">
            <div class="message-content">
                Здравствуйте! Чем могу помочь?
            </div>
            <div class="message-time">сейчас</div>
        </div>
    </div>
    <div class="chat-footer">
        <div class="input-group">
            <input type="text" class="form-control" id="chatInput" placeholder="Введите сообщение...">
            <button class="btn btn-primary" id="sendChatBtn">
                <i class="fas fa-paper-plane"></i>
            </button>
        </div>
    </div>
</div>

<style>
.contact-icon {
    height: 100px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.schedule-item {
    display: flex;
    justify-content: space-between;
    padding: 10px 0;
    border-bottom: 1px solid rgba(0,0,0,0.1);
}

.schedule-item:last-child {
    border-bottom: none;
}

.schedule-item.holiday {
    background-color: rgba(255, 193, 7, 0.1);
    padding: 10px;
    border-radius: 5px;
    margin-top: 10px;
}

.day {
    font-weight: 500;
}

.time {
    color: var(--primary-color);
    font-weight: bold;
}

.map-placeholder {
    border: 2px dashed #dee2e6;
}

/* Стили для чата */
.chat-container {
    position: fixed;
    bottom: 20px;
    right: 20px;
    width: 350px;
    height: 500px;
    background: white;
    border-radius: 10px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.2);
    display: flex;
    flex-direction: column;
    z-index: 1000;
}

.chat-header {
    background: var(--primary-color);
    color: white;
    padding: 15px;
    border-radius: 10px 10px 0 0;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.chat-body {
    flex-grow: 1;
    padding: 15px;
    overflow-y: auto;
    background: #f8f9fa;
}

.chat-footer {
    padding: 15px;
    border-top: 1px solid #dee2e6;
}

.chat-message {
    margin-bottom: 15px;
    max-width: 80%;
}

.chat-message.bot {
    margin-right: auto;
}

.chat-message.user {
    margin-left: auto;
}

.message-content {
    padding: 10px 15px;
    border-radius: 15px;
    display: inline-block;
}

.chat-message.bot .message-content {
    background: white;
    border: 1px solid #dee2e6;
}

.chat-message.user .message-content {
    background: var(--primary-color);
    color: white;
}

.message-time {
    font-size: 0.75rem;
    color: #6c757d;
    margin-top: 5px;
}

@media (max-width: 768px) {
    .chat-container {
        width: 100%;
        height: 100%;
        bottom: 0;
        right: 0;
        border-radius: 0;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Чат поддержки
    const openChatBtn = document.getElementById('openChatBtn');
    const closeChatBtn = document.getElementById('closeChatBtn');
    const chatContainer = document.getElementById('chatContainer');
    const chatInput = document.getElementById('chatInput');
    const sendChatBtn = document.getElementById('sendChatBtn');
    const chatBody = document.getElementById('chatBody');
    
    if (openChatBtn) {
        openChatBtn.addEventListener('click', function() {
            chatContainer.style.display = 'flex';
            chatInput.focus();
        });
    }
    
    if (closeChatBtn) {
        closeChatBtn.addEventListener('click', function() {
            chatContainer.style.display = 'none';
        });
    }
    
    function addMessage(message, isUser = false) {
        const messageDiv = document.createElement('div');
        messageDiv.className = `chat-message ${isUser ? 'user' : 'bot'}`;
        
        const now = new Date();
        const time = now.getHours().toString().padStart(2, '0') + ':' + 
                     now.getMinutes().toString().padStart(2, '0');
        
        messageDiv.innerHTML = `
            <div class="message-content">${message}</div>
            <div class="message-time">${time}</div>
        `;
        
        chatBody.appendChild(messageDiv);
        chatBody.scrollTop = chatBody.scrollHeight;
    }
    
    function sendMessage() {
        const message = chatInput.value.trim();
        if (!message) return;
        
        addMessage(message, true);
        chatInput.value = '';
        
        // Имитация ответа бота
        setTimeout(() => {
            const responses = [
                "Спасибо за сообщение! Наш оператор ответит вам в ближайшее время.",
                "Понял ваш вопрос. Уточните, пожалуйста, номер заказа?",
                "Для решения вашего вопроса нам понадобится дополнительная информация.",
                "Сейчас передам ваш вопрос специалисту соответствующего отдела.",
                "Благодарим за обращение! Мы работаем над вашим вопросом."
            ];
            const randomResponse = responses[Math.floor(Math.random() * responses.length)];
            addMessage(randomResponse, false);
        }, 1000);
    }
    
    if (sendChatBtn && chatInput) {
        sendChatBtn.addEventListener('click', sendMessage);
        
        chatInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                sendMessage();
            }
        });
    }
    
    // Форма обратной связи
    const contactForm = document.getElementById('contactForm');
    
    if (contactForm) {
        contactForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Собираем данные
            const formData = new FormData();
            formData.append('name', document.getElementById('contactName').value);
            formData.append('email', document.getElementById('contactEmail').value);
            formData.append('subject', document.getElementById('contactSubject').value);
            formData.append('message', document.getElementById('contactMessage').value);
            formData.append('order_number', document.getElementById('orderNumber').value);
            formData.append('subscribe', document.getElementById('subscribeNewsletter').checked);
            
            const fileInput = document.getElementById('fileAttachment');
            if (fileInput.files[0]) {
                if (fileInput.files[0].size > 10 * 1024 * 1024) { // 10MB
                    showNotification('Файл слишком большой (максимум 10MB)', 'error');
                    return;
                }
                formData.append('attachment', fileInput.files[0]);
            }
            
            // Отправляем запрос
            fetch('/api/contact.php', {
                method: 'POST',
                headers: {
                    'X-CSRF-Token': window.App.csrfToken
                },
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    showNotification('Сообщение успешно отправлено! Мы ответим в течение 24 часов.', 'success');
                    contactForm.reset();
                } else {
                    showNotification(data.error || 'Ошибка отправки сообщения', 'error');
                }
            })
            .catch(error => {
                showNotification('Ошибка соединения с сервером', 'error');
                console.error('Error:', error);
            });
        });
    }
    
    // Анимация иконок контактов
    const contactIcons = document.querySelectorAll('.contact-icon i');
    contactIcons.forEach(icon => {
        icon.addEventListener('mouseenter', function() {
            this.style.transform = 'scale(1.1) rotate(5deg)';
            this.style.transition = 'transform 0.3s';
        });
        
        icon.addEventListener('mouseleave', function() {
            this.style.transform = 'scale(1) rotate(0)';
        });
    });
});
</script>

<?php include 'templates/footer.php'; ?>