<?php
require_once 'includes/config.php';
require_once 'includes/functions.php';

$title = "Как скачать купленный товар - инструкция";
$theme = isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light';

include 'templates/header.php';
?>

<div class="container py-5">
    <!-- Заголовок -->
    <div class="row mb-5">
        <div class="col-12">
            <h1 class="display-5 mb-3">
                <i class="fas fa-download text-success me-2"></i>Как скачать купленный товар
            </h1>
            <p class="lead text-muted">
                Получите мгновенный доступ к скачиванию купленных цифровых товаров. 
                Простые способы скачивания через email и личный кабинет.
            </p>
        </div>
    </div>
    
    <!-- Основные способы скачивания -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="mb-4">Способы скачивания покупок</h2>
            
            <div class="row">
                <!-- Способ 1 -->
                <div class="col-md-4 mb-4">
                    <div class="card h-100 border-success text-center">
                        <div class="card-body">
                            <div class="download-method-icon mb-4">
                                <i class="fas fa-envelope fa-4x text-success"></i>
                            </div>
                            <h4 class="card-title">Через email</h4>
                            <p class="card-text text-muted">
                                После оплаты на ваш email придет письмо со ссылкой для скачивания
                            </p>
                            <div class="mt-3">
                                <span class="badge bg-success">Рекомендуемый способ</span>
                            </div>
                        </div>
                        <div class="card-footer bg-transparent">
                            <small class="text-muted">
                                <i class="fas fa-check-circle me-1"></i>
                                Ссылка действительна 7 дней
                            </small>
                        </div>
                    </div>
                </div>
                
                <!-- Способ 2 -->
                <div class="col-md-4 mb-4">
                    <div class="card h-100 border-primary text-center">
                        <div class="card-body">
                            <div class="download-method-icon mb-4">
                                <i class="fas fa-user-circle fa-4x text-primary"></i>
                            </div>
                            <h4 class="card-title">В личном кабинете</h4>
                            <p class="card-text text-muted">
                                Авторизуйтесь на сайте и перейдите в раздел "Мои заказы"
                            </p>
                        </div>
                        <div class="card-footer bg-transparent">
                            <small class="text-muted">
                                <i class="fas fa-infinity me-1"></i>
                                Бессрочный доступ к покупкам
                            </small>
                        </div>
                    </div>
                </div>
                
                <!-- Способ 3 -->
                <div class="col-md-4 mb-4">
                    <div class="card h-100 border-info text-center">
                        <div class="card-body">
                            <div class="download-method-icon mb-4">
                                <i class="fas fa-link fa-4x text-info"></i>
                            </div>
                            <h4 class="card-title">Прямая ссылка</h4>
                            <p class="card-text text-muted">
                                Используйте прямую ссылку из письма или личного кабинета
                            </p>
                        </div>
                        <div class="card-footer bg-transparent">
                            <small class="text-muted">
                                <i class="fas fa-redo me-1"></i>
                                До 3 скачиваний по одной ссылке
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Пошаговая инструкция -->
    <div class="row mb-5">
        <div class="col-12">
            <h3 class="mb-4">Пошаговая инструкция по скачиванию</h3>
            
            <div class="row">
                <div class="col-lg-6">
                    <div class="card mb-4">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-envelope me-2"></i>Скачивание через email
                            </h5>
                        </div>
                        <div class="card-body">
                            <ol class="steps-list">
                                <li>
                                    <strong>Проверьте ваш email</strong>
                                    <p class="small text-muted mb-2">
                                        После успешной оплаты проверьте почту, указанную при оформлении заказа
                                    </p>
                                </li>
                                <li>
                                    <strong>Найдите письмо от магазина</strong>
                                    <p class="small text-muted mb-2">
                                        Тема письма: "Ваш заказ #НОМЕР оплачен" или "Ссылка для скачивания"
                                    </p>
                                </li>
                                <li>
                                    <strong>Откройте письмо и нажмите на ссылку</strong>
                                    <p class="small text-muted mb-2">
                                        В письме будет ссылка для скачивания купленного товара
                                    </p>
                                </li>
                                <li>
                                    <strong>Скачайте файл</strong>
                                    <p class="small text-muted mb-0">
                                        Нажмите "Скачать" на открывшейся странице
                                    </p>
                                </li>
                            </ol>
                            
                            <div class="alert alert-warning mt-3 small">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                Проверьте папку "Спам", если не видите письмо в основной почте
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-6">
                    <div class="card mb-4">
                        <div class="card-header bg-primary text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-user-circle me-2"></i>Скачивание через личный кабинет
                            </h5>
                        </div>
                        <div class="card-body">
                            <ol class="steps-list">
                                <li>
                                    <strong>Войдите в аккаунт</strong>
                                    <p class="small text-muted mb-2">
                                        <a href="/login.php">Авторизуйтесь</a> на сайте, используя email и пароль
                                    </p>
                                </li>
                                <li>
                                    <strong>Перейдите в "Мои заказы"</strong>
                                    <p class="small text-muted mb-2">
                                        В личном кабинете нажмите на раздел "Мои заказы" или "История покупок"
                                    </p>
                                </li>
                                <li>
                                    <strong>Выберите нужный заказ</strong>
                                    <p class="small text-muted mb-2">
                                        Найдите заказ, который хотите скачать, и нажмите "Скачать"
                                    </p>
                                </li>
                                <li>
                                    <strong>Скачайте товар</strong>
                                    <p class="small text-muted mb-0">
                                        Нажмите на кнопку скачивания рядом с нужным товаром
                                    </p>
                                </li>
                            </ol>
                            
                            <div class="alert alert-info mt-3 small">
                                <i class="fas fa-info-circle me-2"></i>
                                В личном кабинете доступны все ваши покупки, даже старые
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Решение проблем -->
    <div class="row mb-5">
        <div class="col-12">
            <div class="card border-warning">
                <div class="card-header bg-warning text-dark">
                    <h5 class="mb-0">
                        <i class="fas fa-wrench me-2"></i>Решение проблем со скачиванием
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="problem-solution">
                                <h6>
                                    <i class="fas fa-envelope text-danger me-2"></i>
                                    Не пришло письмо со ссылкой
                                </h6>
                                <p class="small text-muted">
                                    <strong>Решение:</strong> Проверьте папку "Спам". Если письма нет, 
                                    <a href="/contacts.php">свяжитесь с поддержкой</a> и укажите номер заказа.
                                </p>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <div class="problem-solution">
                                <h6>
                                    <i class="fas fa-link text-danger me-2"></i>
                                    Ссылка не работает или истек срок
                                </h6>
                                <p class="small text-muted">
                                    <strong>Решение:</strong> Войдите в личный кабинет и скачайте оттуда. 
                                    Ссылки в личном кабинете работают всегда.
                                </p>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <div class="problem-solution">
                                <h6>
                                    <i class="fas fa-ban text-danger me-2"></i>
                                    Превышено количество скачиваний
                                </h6>
                                <p class="small text-muted">
                                    <strong>Решение:</strong> Одна ссылка позволяет скачать файл до 3 раз. 
                                    Для дополнительных скачиваний обратитесь в поддержку.
                                </p>
                            </div>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <div class="problem-solution">
                                <h6>
                                    <i class="fas fa-file-archive text-danger me-2"></i>
                                    Файл поврежден или не открывается
                                </h6>
                                <p class="small text-muted">
                                    <strong>Решение:</strong> Попробуйте скачать файл еще раз. Если проблема 
                                    повторяется, обратитесь в поддержку для получения нового файла.
                                </p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-center mt-4">
                        <a href="/contacts.php" class="btn btn-warning">
                            <i class="fas fa-headset me-2"></i>Обратиться в поддержку
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Частые вопросы -->
    <div class="row mb-5">
        <div class="col-12">
            <h3 class="mb-4">Частые вопросы о скачивании</h3>
            
            <div class="accordion" id="downloadQuestions">
                <!-- Вопрос 1 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="downloadHeadingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#downloadCollapseOne">
                            Сколько времени действительна ссылка для скачивания?
                        </button>
                    </h3>
                    <div id="downloadCollapseOne" class="accordion-collapse collapse show" data-bs-parent="#downloadQuestions">
                        <div class="accordion-body">
                            <strong>Ссылка из email действительна 7 дней</strong> с момента отправки. 
                            Однако в личном кабинете вы можете скачивать купленные товары бессрочно. 
                            Рекомендуем <a href="/register.php">зарегистрировать аккаунт</a> для постоянного доступа к покупкам.
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 2 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="downloadHeadingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#downloadCollapseTwo">
                            Сколько раз можно скачать купленный товар?
                        </button>
                    </h3>
                    <div id="downloadCollapseTwo" class="accordion-collapse collapse" data-bs-parent="#downloadQuestions">
                        <div class="accordion-body">
                            <strong>До 3 раз по одной ссылке.</strong> Если вам нужно больше скачиваний, 
                            войдите в личный кабинет - там ограничений нет. Также вы можете запросить 
                            новую ссылку у поддержки, если превысили лимит.
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 3 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="downloadHeadingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#downloadCollapseThree">
                            Можно ли скачать товар на несколько устройств?
                        </button>
                    </h3>
                    <div id="downloadCollapseThree" class="accordion-collapse collapse" data-bs-parent="#downloadQuestions">
                        <div class="accordion-body">
                            <strong>Да, конечно!</strong> Вы можете скачать купленный товар на любое количество 
                            своих устройств. Ограничение только на количество скачиваний по одной ссылке 
                            (3 раза), но в личном кабинете вы можете скачивать неограниченно.
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 4 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="downloadHeadingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#downloadCollapseFour">
                            Что делать, если я купил товар без регистрации?
                        </button>
                    </h3>
                    <div id="downloadCollapseFour" class="accordion-collapse collapse" data-bs-parent="#downloadQuestions">
                        <div class="accordion-body">
                            Если вы совершили покупку без регистрации, используйте ссылку из email. 
                            Для долгосрочного доступа к покупкам рекомендуется 
                            <a href="/register.php">зарегистрировать аккаунт</a> с тем же email, 
                            который использовался при покупке. После регистрации все покупки автоматически 
                            появятся в вашем личном кабинете.
                        </div>
                    </div>
                </div>
                
                <!-- Вопрос 5 -->
                <div class="accordion-item">
                    <h3 class="accordion-header" id="downloadHeadingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#downloadCollapseFive">
                            Какие форматы файлов вы предлагаете?
                        </button>
                    </h3>
                    <div id="downloadCollapseFive" class="accordion-collapse collapse" data-bs-parent="#downloadQuestions">
                        <div class="accordion-body">
                            Мы предлагаем товары в различных форматах:
                            <ul class="mt-2">
                                <li><strong>Архивы:</strong> ZIP, RAR, 7Z</li>
                                <li><strong>Документы:</strong> PDF, DOC, DOCX, XLS, XLSX</li>
                                <li><strong>Изображения:</strong> JPG, PNG, GIF, SVG, PSD</li>
                                <li><strong>Видео:</strong> MP4, AVI, MOV</li>
                                <li><strong>Программы:</strong> EXE, MSI, DMG</li>
                            </ul>
                            Формат каждого товара указан на его странице перед покупкой.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Дополнительная информация -->
    <div class="row">
        <div class="col-12">
            <div class="card bg-light">
                <div class="card-body">
                    <h5 class="card-title mb-3">
                        <i class="fas fa-info-circle text-primary me-2"></i>Дополнительная информация
                    </h5>
                    
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <h6><i class="fas fa-compress-arrows-alt me-2"></i>Размер файлов</h6>
                            <p class="small text-muted mb-0">
                                Размер каждого товара указан на его странице. 
                                Убедитесь, что у вас достаточно свободного места на устройстве.
                            </p>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <h6><i class="fas fa-virus me-2"></i>Защита от вирусов</h6>
                            <p class="small text-muted mb-0">
                                Все товары проверяются на вирусы перед публикацией. 
                                Однако рекомендуем проверять скачанные файлы антивирусом.
                            </p>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <h6><i class="fas fa-key me-2"></i>Лицензия и активация</h6>
                            <p class="small text-muted mb-0">
                                Инструкции по активации и лицензионные ключи (если требуются) 
                                находятся внутри архива или в описании товара.
                            </p>
                        </div>
                        
                        <div class="col-md-6 mb-3">
                            <h6><i class="fas fa-cloud-download-alt me-2"></i>Скорость скачивания</h6>
                            <p class="small text-muted mb-0">
                                Скорость скачивания зависит от вашего интернет-соединения. 
                                Все файлы хранятся на быстрых серверах.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.download-method-icon {
    height: 100px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.steps-list {
    list-style: none;
    padding-left: 0;
    counter-reset: step-counter;
}

.steps-list li {
    counter-increment: step-counter;
    margin-bottom: 20px;
    padding-left: 40px;
    position: relative;
}

.steps-list li::before {
    content: counter(step-counter);
    position: absolute;
    left: 0;
    top: 0;
    width: 30px;
    height: 30px;
    background: var(--success-color, #28a745);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
}

.problem-solution {
    padding: 15px;
    background: rgba(255, 193, 7, 0.1);
    border-radius: 8px;
    border-left: 4px solid #ffc107;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Анимация карточек методов скачивания
    const methodCards = document.querySelectorAll('.download-method-icon');
    methodCards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.querySelector('i').style.transform = 'scale(1.1)';
            this.querySelector('i').style.transition = 'transform 0.3s';
        });
        
        card.addEventListener('mouseleave', function() {
            this.querySelector('i').style.transform = 'scale(1)';
        });
    });
    
    // Копирование ссылки для скачивания (пример)
    document.querySelectorAll('.copy-link-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const link = this.getAttribute('data-link');
            navigator.clipboard.writeText(link).then(() => {
                const originalText = this.innerHTML;
                this.innerHTML = '<i class="fas fa-check me-1"></i>Скопировано';
                this.classList.remove('btn-outline-info');
                this.classList.add('btn-success');
                
                setTimeout(() => {
                    this.innerHTML = originalText;
                    this.classList.remove('btn-success');
                    this.classList.add('btn-outline-info');
                }, 2000);
            });
        });
    });
});
</script>

<?php include 'templates/footer.php'; ?>