<?php
require_once '../config.php';

class YooMoneyPayment {
    
    public static function createPayment($orderId, $amount, $description) {
        $params = [
            'amount' => number_format($amount, 2, '.', ''),
            'currency' => 'RUB',
            'payment_id' => $orderId,
            'description' => $description,
            'return_url' => SITE_URL . '/checkout-success.php',
            'capture' => true
        ];
        
        // Создание платежа через API ЮMoney
        $ch = curl_init('https://api.yookassa.ru/v3/payments');
        curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
        curl_setopt($ch, CURLOPT_USERPWD, YOOMONEY_WALLET . ':' . YOOMONEY_SECRET);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Idempotence-Key: ' . uniqid()
        ]);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        return json_decode($response, true);
    }
    
    public static function verifyNotification($data) {
        // Проверяем подпись уведомления
        $hash = $data['sha1_hash'];
        unset($data['sha1_hash']);
        
        ksort($data);
        $string = implode('&', array_map(
            function ($v, $k) { return $k . '=' . $v; },
            $data,
            array_keys($data)
        ));
        
        $calculatedHash = sha1($string . YOOMONEY_SECRET);
        
        return hash_equals($calculatedHash, $hash);
    }
}
?>