<?php
require_once 'includes/config.php';
require_once 'includes/functions.php';

$title = "Главная - " . SITE_NAME;
$theme = isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light';

include 'templates/header.php';
?>

<div class="container">
    <h1 class="mb-4">Популярные товары</h1>
    
    <div class="row" id="products-container">
        <?php
        $products = getProducts(8, 0);
        while ($product = $products->fetch_assoc()) {
            include 'templates/product-card.php';
        }
        ?>
    </div>
    
    <div class="text-center mt-4">
        <a href="catalog.php" class="btn btn-primary btn-lg">Смотреть все товары</a>
    </div>
</div>

<?php include 'templates/footer.php'; ?>