<?php
// Начинаем буферизацию для обработки вывода
ob_start();

// Определяем активную тему
$theme = isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light';
$theme_cookie = isset($_COOKIE['theme']) ? $_COOKIE['theme'] : 'light';

// Проверяем авторизацию
$is_logged_in = isset($_SESSION['user_id']);
$user_name = $is_logged_in ? $_SESSION['user_name'] : '';
$user_role = $is_logged_in ? $_SESSION['user_role'] : '';
$is_admin = $user_role === 'admin';
$is_moderator = in_array($user_role, ['admin', 'moderator']);

// Получаем количество товаров в корзине
$cart_count = 0;
if ($is_logged_in) {
    $db = db();
    $stmt = $db->prepare("SELECT COUNT(*) as count FROM cart WHERE user_id = ?");
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    $cart_count = $result->fetch_assoc()['count'];
} elseif (isset($_SESSION['cart']) && is_array($_SESSION['cart'])) {
    $cart_count = count($_SESSION['cart']);
}

// Определяем активную страницу
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="ru" data-theme="<?php echo $theme; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    
    <title><?php echo isset($title) ? htmlspecialchars($title) : 'Digital Store'; ?></title>
    
    <!-- Favicon -->
    <link rel="apple-touch-icon" sizes="180x180" href="/assets/images/favicon/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="/assets/images/favicon/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="/assets/images/favicon/favicon-16x16.png">
    <!-- <link rel="manifest" href="/assets/images/favicon/site.webmanifest"> -->
    
    <!-- Основной CSS -->
    <link rel="stylesheet" href="/assets/css/style.css">
    
    <!-- Динамическая загрузка темы -->
    <link rel="stylesheet" href="/assets/css/<?php echo $theme; ?>-theme.css" id="theme-css">
    
    <!-- Bootstrap 5 (опционально, для быстрой разработки) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome для иконок -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Шрифты -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Мета-теги для SEO -->
    <meta name="description" content="<?php echo isset($meta_description) ? htmlspecialchars($meta_description) : 'Магазин цифровых товаров - программы, игры, шаблоны, курсы и графика.'; ?>">
    <meta name="keywords" content="цифровые товары, программы, игры, курсы, шаблоны, графика">
    <meta name="author" content="Digital Store">
    
    <!-- Open Graph для социальных сетей -->
    <meta property="og:title" content="<?php echo isset($title) ? htmlspecialchars($title) : 'Digital Store'; ?>">
    <meta property="og:description" content="<?php echo isset($meta_description) ? htmlspecialchars($meta_description) : 'Магазин цифровых товаров'; ?>">
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo SITE_URL . $_SERVER['REQUEST_URI']; ?>">
    <meta property="og:image" content="<?php echo SITE_URL; ?>/assets/images/og-image.jpg">
    
    <!-- Канонический URL -->
    <link rel="canonical" href="<?php echo SITE_URL . $_SERVER['REQUEST_URI']; ?>">
    
    <!-- CSRF токен для JavaScript -->
    <meta name="csrf-token" content="<?php echo isset($_SESSION['csrf_token']) ? $_SESSION['csrf_token'] : ''; ?>">
    
    <style>
        /* Быстрые стили для предотвращения FOUC (Flash of Unstyled Content) */
        html {
            visibility: hidden;
            opacity: 0;
        }
        html.loaded {
            visibility: visible;
            opacity: 1;
            transition: opacity 0.3s ease;
        }
        
        /* Стили для корзины */
        .cart-badge {
            position: absolute;
            top: -5px;
            right: -5px;
            background-color: var(--danger-color);
            color: white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            font-size: 11px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        /* Анимации */
        .bounce {
            animation: bounce 0.3s;
        }
        
        @keyframes bounce {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.2); }
        }
        
        /* Предзагрузка важных изображений */
        .preload-images {
            position: absolute;
            width: 0;
            height: 0;
            overflow: hidden;
            z-index: -1;
        }
    </style>
</head>
<body>
    <!-- Предзагрузка изображений -->
    <div class="preload-images">
        <img src="/assets/images/default-product.jpg" alt="">
        <img src="/assets/images/logo.png" alt="">
    </div>
    
    <!-- Уведомления (если есть) -->
    <?php if (isset($_SESSION['notification'])): ?>
        <div class="notification-alert alert alert-<?php echo $_SESSION['notification']['type']; ?> alert-dismissible fade show" role="alert">
            <?php echo $_SESSION['notification']['message']; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php unset($_SESSION['notification']); ?>
    <?php endif; ?>
    
    <!-- Навигация -->
<nav class="navbar navbar-expand-lg navbar-light sticky-top">
    <div class="container">
        <!-- Логотип -->
        <a class="navbar-brand" href="/">
            <i class="fas fa-store me-2"></i>
            <strong><?php echo SITE_NAME; ?></strong>
        </a>
        
        <!-- Поиск и переключатель темы в шапке (до бургер-меню) -->
        <div class="d-flex align-items-center order-lg-1">
            <!-- Переключатель темы -->
            <button class="nav-link theme-switch me-2" onclick="toggleTheme()" title="Сменить тему">
                <i class="fas fa-moon" id="theme-icon"></i>
            </button>
            
            <!-- Корзина -->
            <a class="nav-link position-relative me-2" href="/cart.php" title="Корзина">
                <i class="fas fa-shopping-cart" id="cart-icon"></i>
                <?php if ($cart_count > 0): ?>
                <span class="cart-badge" id="cart-count"><?php echo $cart_count; ?></span>
                <?php endif; ?>
            </a>
            
            <!-- Кнопка для мобильных -->
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
        </div>
        
        <!-- Меню -->
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav me-auto">
                <li class="nav-item">
                    <a class="nav-link <?php echo $current_page == 'index.php' ? 'active' : ''; ?>" href="/">
                        <i class="fas fa-home me-1"></i> Главная
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo $current_page == 'catalog.php' ? 'active' : ''; ?>" href="/catalog.php">
                        <i class="fas fa-th-large me-1"></i> Каталог
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo $current_page == 'categories.php' ? 'active' : ''; ?>" href="/categories.php">
                        <i class="fas fa-tags me-1"></i> Категории
                    </a>
                </li>
                
                <?php if ($is_moderator): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="adminDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-crown me-1"></i> Админ
                    </a>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="/admin/dashboard.php"><i class="fas fa-tachometer-alt me-2"></i>Панель управления</a></li>
                        <li><a class="dropdown-item" href="/admin/products.php"><i class="fas fa-box me-2"></i>Товары</a></li>
                        <li><a class="dropdown-item" href="/admin/orders.php"><i class="fas fa-shopping-cart me-2"></i>Заказы</a></li>
                        <li><a class="dropdown-item" href="/admin/moderation.php"><i class="fas fa-check-circle me-2"></i>Модерация</a></li>
                        <?php if ($is_admin): ?>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="/admin/users.php"><i class="fas fa-users me-2"></i>Пользователи</a></li>
                        <li><a class="dropdown-item" href="/admin/settings.php"><i class="fas fa-cog me-2"></i>Настройки</a></li>
                        <?php endif; ?>
                    </ul>
                </li>
                <?php endif; ?>
            </ul>
            
            <!-- Правая часть навигации (остается поиск и профиль) -->
            <ul class="navbar-nav ms-auto">
                <!-- Поиск теперь в основном меню -->
                <li class="nav-item d-none d-lg-block">
                    <form class="d-flex search-form" action="/search.php" method="GET">
                        <div class="input-group">
                            <input type="text" class="form-control form-control-sm" 
                                   name="q" placeholder="Поиск товаров..." 
                                   value="<?php echo isset($_GET['q']) ? htmlspecialchars($_GET['q']) : ''; ?>">
                            <button class="btn btn-outline-primary btn-sm" type="submit">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </form>
                </li>
                
                <!-- Профиль пользователя -->
                <?php if ($is_logged_in): ?>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-user me-1"></i> <?php echo htmlspecialchars($user_name); ?>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="/profile.php"><i class="fas fa-user-circle me-2"></i>Профиль</a></li>
                        <li><a class="dropdown-item" href="/orders.php"><i class="fas fa-history me-2"></i>Мои заказы</a></li>
                        <li><a class="dropdown-item" href="/balance.php"><i class="fas fa-wallet me-2"></i>Баланс</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item" href="/logout.php"><i class="fas fa-sign-out-alt me-2"></i>Выйти</a></li>
                    </ul>
                </li>
                <?php else: ?>
                <li class="nav-item">
                    <a class="nav-link <?php echo $current_page == 'login.php' ? 'active' : ''; ?>" href="/login.php">
                        <i class="fas fa-sign-in-alt me-1"></i> Войти
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link <?php echo $current_page == 'register.php' ? 'active' : ''; ?>" href="/register.php">
                        <i class="fas fa-user-plus me-1"></i> Регистрация
                    </a>
                </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>
    
    <!-- Основной контент -->
    <main class="flex-grow-1">