<div class="col-md-3 col-sm-6 mb-4">
    <div class="card product-card h-100">
        <div class="card-img-container">
            <img src="<?php echo $product['image'] ?: 'assets/images/default-product.jpg'; ?>" 
                 class="card-img-top" 
                 alt="<?php echo htmlspecialchars($product['name']); ?>"
                 loading="lazy">
        </div>
        <div class="card-body">
            <h5 class="card-title"><?php echo htmlspecialchars($product['name']); ?></h5>
            <p class="card-text text-muted small"><?php echo htmlspecialchars($product['category_name']); ?></p>
            <p class="card-text"><?php echo substr(htmlspecialchars($product['description']), 0, 100); ?>...</p>
            <div class="d-flex justify-content-between align-items-center">
                <span class="price"><?php echo number_format($product['price'], 2); ?> ₽</span>
                <a href="product.php?id=<?php echo $product['id']; ?>" class="btn btn-outline-primary btn-sm">
                    Подробнее
                </a>
            </div>
        </div>
        <div class="card-footer">
            <small class="text-muted">
                <i class="fas fa-download"></i> 
                <?php echo $product['downloads_count']; ?> скачиваний
            </small>
        </div>
    </div>
</div>