<?php
$title = 'Настройки сайта';
require_once '../sys/sys.php';
require_once '../sys/db.php';
require_once '../sys/head.php';

if (!isset($_SESSION['admin'])) {
    echo '<div class="menu">Ошибка! Такой страницы не существует!</div>';
    require_once '../sys/foot.php';
    exit;
}

$query = "SELECT * FROM `sett` LIMIT 1";
$result = $mysqli->query($query);
if (!$result) {
    die('Ошибка при получении настроек: ' . $mysqli->error);
}
if ($result->num_rows === 0) {
    die('Ошибка: Настройки не найдены в таблице `sett`.');
}
$set = $result->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ok'])) {
    $cena = floatval($_POST['cena'] ?? 0.00);
    $wallet_yoo = ($_POST['wallet_yoo'] ?? '');
    $key_yoo = ($_POST['key_yoo'] ?? '');
    $key_payeer = ($_POST['key_payeer'] ?? '');
    $id_payeer = ($_POST['id_payeer'] ?? '');
    $adm = htmlspecialchars($_POST['adm'] ?? '');
    $pass = $_POST['pass'] ?? '';

    $error = '';
    if (empty($adm) || $cena <= 0 || empty($wallet_yoo)) {
        $error .= 'Ошибка! Одно из обязательных полей не заполнено или указана некорректная цена! <br/>';
    }

    if (!empty($error)) {
        echo '<div class="alert alert-danger">' . $error . '</div>';
    } else {
        if (empty($pass)) {
            $query = "UPDATE `sett` SET 
                     `cena` = ?, 
                     `wallet_yoo` = ?,
                     `key_yoo` = ?, `key_payeer` = ?, `id_payeer` = ?,
                     `adm` = ?";
            $stmt = $pdo->prepare($query);
            $params = [$cena, $wallet_yoo, $key_yoo, $key_payeer, $id_payeer, $adm];
        } else {
            $hashed_password = password_hash($pass, PASSWORD_BCRYPT);
            $query = "UPDATE `sett` SET 
                     `cena` = ?, 
                     `wallet_yoo` = ?,
                     `key_yoo` = ?, `key_payeer` = ?, `id_payeer` = ?,
                     `adm` = ?, 
                     `pass` = ?";
            $stmt = $pdo->prepare($query);
            $params = [$cena, $wallet_yoo, $key_yoo, $key_payeer, $id_payeer, $adm, $hashed_password];
        }

        if (!$stmt) {
            error_log('Ошибка подготовки запроса');
            echo '<div class="alert alert-danger">Ошибка при обновлении настроек. Пожалуйста, попробуйте позже.</div>';
        } else if ($stmt->execute($params)) {
            echo '<div class="alert alert-success">Настройки успешно изменены!<br/><a href="/admin/sett">Назад</a></div>';
            require_once '../sys/foot.php';
            exit;
        } else {
            echo '<div class="alert alert-danger">Ошибка при обновлении настроек</div>';
        }
    }
}

echo '<div class="bg-index"><br/>
    <div class="title-page">
        <h2 style="color: #fff;">Настройка формирования цен</h2>
    </div>
    <br/>
</div><br/>
<div class="container">
    <div class="row">
        <div class="col-lg-4 col-md-3"></div>
        <div class="col-lg-4 col-md-6">
            <div class="alert bg-light stat" style="margin-top: -55px;">
                <h5>Настройки сайта</h5><hr>
                <form action="sett" method="post" name="form">
                    <div class="form-group login-form">
                        <label>Цена за 1 день:</label>
                        <input type="text" name="cena" maxlength="5" class="form-control" value="' . $set['cena'] . '"/>
                        
                        <label>ЮMoney:</label>
                        <input type="text" name="wallet_yoo" class="form-control" value="' . htmlspecialchars($set['wallet_yoo']) . '"/>
  
                        <label>ЮMoney Key:</label>
                        <input type="text" name="key_yoo" class="form-control" value="' . htmlspecialchars($set['key_yoo']) . '"/>
                        
                        <label>Payeer Key:</label>
                        <input type="text" name="key_payeer" class="form-control" value="' . htmlspecialchars($set['key_payeer']) . '"/>
                          
                        <label>Payeer ID:</label>
                        <input type="text" name="id_payeer" class="form-control" value="' . htmlspecialchars($set['id_payeer']) . '"/>
                        
                        <label>Логин админки:</label>
                        <input type="text" name="adm" maxlength="15" class="form-control" value="' . htmlspecialchars($set['adm']) . '"/>
                        
                        <label>Пароль админки:</label>
                        <input type="password" name="pass" class="form-control" placeholder="Оставьте пустым, чтобы не менять" value=""/>
                        
                        <input name="ok" type="submit" value="Сохранить" class="btn btn-info btn-lg mt-3" style="width: 100%;"/>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>';

echo '<div class="container">
    <div class="row">
        <div class="col-lg-4 col-md-3"></div>
        <div class="col-lg-4 col-md-6">
            <div class="alert bg-light stat" style="margin-top: -55px;">
                <center><a href="/admin/" class="btn btn-secondary">Админ панель</a></center>
            </div>
        </div>
    </div>
</div>';

require_once '../sys/foot.php';
?>