<?php
declare(strict_types=1);

$title = 'Активные площадки';
require_once 'sys/sys.php';
require_once 'sys/db.php';
require_once 'sys/head.php';

echo '<meta name="description" content="Список активных площадок для iframe трафика на ' . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_QUOTES, 'UTF-8') . '">';
echo '<link rel="canonical" href="https://' . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_QUOTES, 'UTF-8') . $_SERVER['REQUEST_URI'] . '">';
echo '<meta name="robots" content="index, follow">';

if (isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $ip = $_SERVER['REMOTE_ADDR'];
    $updateQuery = "UPDATE `iframe` SET `traffic` = `traffic` + 1 WHERE `id` = ?";
    $stmt = $mysqli->prepare($updateQuery);
    if (!$stmt) {
        die('Ошибка подготовки запроса: ' . $mysqli->error);
    }
    $stmt->bind_param('i', $id);
    if (!$stmt->execute()) {
        die('Ошибка выполнения запроса: ' . $stmt->error);
    }
    $stmt->close();

    $urlQuery = "SELECT `url` FROM `iframe` WHERE `id` = ?";
    $stmt = $mysqli->prepare($urlQuery);
    if (!$stmt) {
        die('Ошибка подготовки запроса: ' . $mysqli->error);
    }
    $stmt->bind_param('i', $id);
    if (!$stmt->execute()) {
        die('Ошибка выполнения запроса: ' . $stmt->error);
    }
    $stmt->bind_result($url);
    $stmt->fetch();
    $stmt->close();

    if ($url) {
        header("Location: " . htmlspecialchars($url, ENT_QUOTES, 'UTF-8'));
        exit();
    } else {
        die("URL не найден для ID: " . $id);
    }
}

$query = 'SELECT `id`, `url`, `expire`, `traffic` FROM `iframe` WHERE `expire` > NOW() AND `status` = "1" ORDER BY RAND() LIMIT 100';
$result = $mysqli->query($query);

if (!$result) {
    die('Ошибка запроса: ' . $mysqli->error);
}

$imr = $result->num_rows;

if ($imr > 0) {
    echo '<div class="bg-index"><br/>
        <div class="title-page">
            <h2 style="color: #fff;">Список заказов</h2>
        </div>
        <div class="container">
            <center>
                <p class="text-light" style="position: relative;z-index: 99;font-size: 120%;">
                    ' . htmlspecialchars($_SERVER['HTTP_HOST'], ENT_QUOTES, 'UTF-8') . ' - iFrame трафик — это невидимые посетители для вашего сайта</p>
            </center>
        </div><br/>
    </div><br/>
    <div class="container">
        <div class="serf" itemscope itemtype="https://schema.org/ItemList">
            <div class="row">';

    while ($link = $result->fetch_assoc()) {
        $id = htmlspecialchars($link['id'], ENT_QUOTES, 'UTF-8');
        $url = htmlspecialchars($link['url'], ENT_QUOTES, 'UTF-8');
        $expire = htmlspecialchars($link['expire'], ENT_QUOTES, 'UTF-8');
        $traffic = htmlspecialchars($link['traffic'], ENT_QUOTES, 'UTF-8');
        $domain = parse_url($url, PHP_URL_HOST) ?: 'сайт';
        
        $updateTrafficQuery = "UPDATE `iframe` SET `traffic` = `traffic` + 1 WHERE `id` = ?";
        $stmt = $mysqli->prepare($updateTrafficQuery);
        if (!$stmt) {
            die('Ошибка подготовки запроса: ' . $mysqli->error);
        }
        $stmt->bind_param('i', $id);
        if (!$stmt->execute()) {
            die('Ошибка выполнения запроса: ' . $stmt->error);
        }
        $stmt->close();
        
        echo '<div class="col-sm-10 normalm" itemprop="itemListElement" itemscope itemtype="https://schema.org/ListItem">
                <meta itemprop="position" content="' . $id . '" />
                <div itemscope itemtype="https://schema.org/WebSite">
                    <iframe width="150" height="60" src="' . $url . '"></iframe>
                    <a href="?id=' . $id . '" target="_blank" rel="nofollow" itemprop="url">
                        <span class="pull-right" style="padding-right: 0;">Активна до: ' . $expire . '</span>
                        <br /><b>URL:</b> ' . $domain . '
                        <br /><b>Трафик:</b> ' . $traffic . '
                    </a>
                </div>
              </div>';
    }

    echo '</div>
        </div>
    </div>';
} else {
    echo '<div class="container">
            <div class="serf">
                <div class="row">
                    <div class="col-sm-10 normalm">
                        <p>Нет активных площадок</p>
                    </div>
                </div>
            </div>
        </div>';
}

echo '<iframe src="https://adred.ru/iframe_url.php" style="display:none"></iframe>
<iframe src="https://adred.ru/home" style="display:none"></iframe>';

require_once 'sys/foot.php';