<?php
declare(strict_types=1);

$host = 'localhost';
$user = '12345';
$pass = '12345';
$db = '12345';

try {
    $mysqli = new mysqli($host, $user, $pass, $db);

    if ($mysqli->connect_error) {
        throw new mysqli_sql_exception("Нет подключения к бд");
    }

    $mysqli->set_charset('utf8');

    $dsn = "mysql:host=" . $host . ";dbname=" . $db . ";charset=utf8mb4";
    $opt = array(
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => true,
        PDO::MYSQL_ATTR_INIT_COMMAND => "SET character_set_results = 'utf8mb4',
                         character_set_client = 'utf8mb4', character_set_connection = 'utf8mb4', character_set_database = 'utf8mb4', character_set_server = 'utf8mb4',
                         sql_mode='STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION'"
    );
    $pdo = new PDO($dsn, $user, $pass, $opt);

    if (!isset($_SESSION)) {
        session_start();
    }

    $tableName = 'sett';
    $result = $mysqli->query("SHOW TABLES LIKE '$tableName'");
    if ($result->num_rows == 0) {
        throw new mysqli_sql_exception("Нет подключения к бд");
    }

} catch (mysqli_sql_exception $e) {
    die('Нет подключения к бд');
} catch (PDOException $e) {
    die('Нет подключения к бд');
}
