<?php

require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/functions.php';

if (!is_admin()) {
    http_response_code(403);
    die("Доступ запрещён");
}

require_once __DIR__ . '/../includes/header.php';
?>

<div class="container my-5">
    <h1 class="mb-4">
        <i class="bi bi-people"></i> Пользователи
    </h1>

    <div class="glass p-4 card-ui fade-in">
        <div class="table-responsive">
            <table class="table table-hover table-striped align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>#ID</th>
                        <th>Email</th>
                        <th>Имя</th>
                        <th>Роль</th>
                        <th>Телефон</th>
                        <th>Дата регистрации</th>
                        <th>Действия</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    try {
                        $stmt = $pdo->query("SELECT id, email, name, phone, role, created_at FROM users ORDER BY id DESC");
                        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
                        
                        if (empty($users)) {
                            echo '<tr><td colspan="7" class="text-center text-muted py-4">Нет пользователей</td></tr>';
                        } else {
                            foreach ($users as $u):
                    ?>
                    <tr>
                        <td><?= e($u['id']) ?></td>
                        <td><?= e($u['email']) ?></td>
                        <td><?= e($u['name']) ?></td>
                        <td>
                            <span class="badge <?= $u['role'] === 'admin' ? 'bg-danger' : 'bg-primary' ?>">
                                <?= e($u['role'] === 'admin' ? 'Админ' : 'Пользователь') ?>
                            </span>
                        </td>
                        <td><?= e($u['phone'] ?? '—') ?></td>
                        <td><?= date('d.m.Y H:i', strtotime($u['created_at'])) ?></td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <button class="btn btn-outline-warning" onclick="editUser(<?= $u['id'] ?>)">
                                    <i class="bi bi-pencil"></i> Изменить
                                </button>
                                <button class="btn btn-outline-danger" onclick="deleteUser(<?= $u['id'] ?>)">
                                    <i class="bi bi-trash"></i> Удалить
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php 
                            endforeach;
                        }
                    } catch (Exception $e) {
                        echo '<tr><td colspan="7" class="text-center text-danger py-4">Ошибка загрузки пользователей: ' . e($e->getMessage()) . '</td></tr>';
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function deleteUser(userId) {
    if (!confirm("Вы уверены, что хотите удалить этого пользователя?")) return;
    
    const csrfToken = document.querySelector('input[name="csrf"]')?.value || '<?= $_SESSION['csrf_token'] ?? '' ?>';
    
    fetch('/ajax/admin/admin_delete_user.php', {  // Изменён путь
        method: 'POST',
        headers: { 
            'Content-Type': 'application/json'
        },
        body: JSON.stringify({
            id: userId,
            csrf: csrfToken
        })
    })
    .then(res => {
        if (!res.ok) {
            throw new Error('Network response was not ok: ' + res.status);
        }
        return res.json();
    })
    .then(data => {
        if (data.success) {
            alert('Пользователь успешно удалён');
            location.reload();
        } else {
            alert('Ошибка: ' + (data.error || 'Неизвестная ошибка'));
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Ошибка соединения с сервером. Проверьте консоль разработчика.');
    });
}

function editUser(userId) {
    window.location.href = '/admin/edit_user.php?id=' + userId;
}
</script>

<?php 
require_once __DIR__ . '/../includes/footer.php'; 
?>