<?php
require_once __DIR__ . '/../../config/bootstrap.php';
require_once __DIR__ . '/../../config/auth.php';
require_once __DIR__ . '/../../config/functions.php';

header('Content-Type: application/json');

if (!is_admin()) {
    echo json_encode(['success' => false, 'error' => 'Доступ запрещён']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Неверный метод запроса']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!$input) {

    $input = $_POST;
}

$csrf_token = $input['csrf'] ?? '';
$user_id = (int)($input['id'] ?? 0);

if (empty($csrf_token) || !check_csrf($csrf_token)) {
    echo json_encode(['success' => false, 'error' => 'Неверный CSRF токен']);
    exit;
}

if ($user_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Неверный ID пользователя']);
    exit;
}

if ($user_id === $_SESSION['user_id']) {
    echo json_encode(['success' => false, 'error' => 'Нельзя удалить самого себя']);
    exit;
}

try {

    $stmt = $pdo->prepare("SELECT id, email FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo json_encode(['success' => false, 'error' => 'Пользователь не найден']);
        exit;
    }

    $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
    $success = $stmt->execute([$user_id]);
    
    if ($success) {

        error_log("Пользователь удалён: ID={$user_id}, Email={$user['email']}, Админ=" . $_SESSION['user_id']);
        
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Ошибка удаления пользователя']);
    }
    
} catch (Exception $e) {
    error_log("Ошибка удаления пользователя: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Внутренняя ошибка сервера: ' . $e->getMessage()]);
}