<?php

require_once __DIR__ . '/../../config/bootstrap.php';
require_once __DIR__ . '/../../config/auth.php';
require_once __DIR__ . '/../../config/functions.php';

header('Content-Type: application/json');

if (!is_admin()) {
    echo json_encode(['success' => false, 'error' => 'Доступ запрещён']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Неверный метод запроса']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);
if (!$input) {
    $input = $_POST;
}

$csrf_token = $input['csrf'] ?? '';
$discount_id = (int)($input['id'] ?? 0);

if (empty($csrf_token) || !check_csrf($csrf_token)) {
    echo json_encode(['success' => false, 'error' => 'Неверный CSRF токен']);
    exit;
}

if ($discount_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Неверный ID скидки']);
    exit;
}

try {
    $stmt = $pdo->prepare("DELETE FROM discounts WHERE id = ?");
    $success = $stmt->execute([$discount_id]);
    
    if ($success) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Ошибка удаления скидки']);
    }
    
} catch (Exception $e) {
    error_log("Ошибка удаления скидки: " . $e->getMessage());
    echo json_encode(['success' => false, 'error' => 'Внутренняя ошибка сервера']);
}
?>