<?php

session_start();
require '../config/bootstrap.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'error' => 'Необходимо войти в систему']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'error' => 'Метод не поддерживается']);
    exit;
}

$csrf = $_POST['csrf'] ?? '';
$item_id = $_POST['item_id'] ?? '';

error_log('Cart remove request: item_id=' . $item_id);
error_log('CSRF token: ' . $csrf);
error_log('Session CSRF: ' . ($_SESSION['csrf_token'] ?? 'none'));

if (empty($csrf) || !check_csrf($csrf)) {
    echo json_encode([
        'success' => false, 
        'error' => 'Неверный CSRF токен',
        'debug' => [
            'received' => $csrf,
            'expected' => $_SESSION['csrf_token'] ?? 'none'
        ]
    ]);
    exit;
}

if (empty($item_id)) {
    echo json_encode(['success' => false, 'error' => 'Не указан товар']);
    exit;
}

if (isset($_SESSION['cart'][$item_id])) {
    unset($_SESSION['cart'][$item_id]);
    echo json_encode([
        'success' => true, 
        'message' => 'Товар удален из корзины',
        'cart_count' => count($_SESSION['cart']),
        'cart_items' => $_SESSION['cart']
    ]);
} else {
    echo json_encode(['success' => false, 'error' => 'Товар не найден в корзине']);
}
?>