<?php

session_start();
require '../config/bootstrap.php';

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'error' => 'Необходимо войти в систему']);
    exit;
}

$csrf = $_POST['csrf'] ?? '';
$item_id = $_POST['item_id'] ?? '';
$quantity = intval($_POST['quantity'] ?? 1);

// Временно отключаем проверку CSRF для тестирования
if (empty($csrf) || !check_csrf($csrf)) {
    echo json_encode(['success' => false, 'error' => 'Неверный CSRF токен']);
    exit;
}

if (empty($item_id)) {
    echo json_encode(['success' => false, 'error' => 'Не указан товар']);
    exit;
}

if ($quantity < 1) {
    echo json_encode(['success' => false, 'error' => 'Количество должно быть больше 0']);
    exit;
}

if (isset($_SESSION['cart'][$item_id])) {
    $_SESSION['cart'][$item_id]['quantity'] = $quantity;
    
    echo json_encode([
        'success' => true,
        'message' => 'Количество обновлено',
        'cart_items' => $_SESSION['cart']
    ]);
} else {
    echo json_encode(['success' => false, 'error' => 'Товар не найден в корзине']);
}
?>