<?php

session_start();
require '../config/bootstrap.php';
require '../config/auth.php';

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'error' => 'Необходимо войти в систему']);
    exit;
}

$order_id = intval($_POST['order_id'] ?? 0);
$action = $_POST['action'] ?? '';
$csrf = $_POST['csrf'] ?? '';

if (empty($csrf) || !check_csrf($csrf)) {
    echo json_encode(['success' => false, 'error' => 'Ошибка безопасности']);
    exit;
}

if ($order_id <= 0) {
    echo json_encode(['success' => false, 'error' => 'Неверный ID заказа']);
    exit;
}

try {
    global $pdo;
    $stmt = $pdo->prepare("SELECT id, status FROM orders WHERE id = ? AND user_id = ?");
    $stmt->execute([$order_id, $_SESSION['user_id']]);
    $order = $stmt->fetch();
    
    if (!$order) {
        echo json_encode(['success' => false, 'error' => 'Заказ не найден']);
        exit;
    }

    if ($action === 'cancel') {

        if ($order['status'] !== 'Новый') {
            echo json_encode(['success' => false, 'error' => 'Можно отменить только новые заказы']);
            exit;
        }
        
        $stmt = $pdo->prepare("UPDATE orders SET status = 'Отменен' WHERE id = ?");
        $stmt->execute([$order_id]);
        
        echo json_encode(['success' => true, 'message' => 'Заказ отменен']);
    } else {
        echo json_encode(['success' => false, 'error' => 'Неизвестное действие']);
    }
    
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Ошибка базы данных: ' . $e->getMessage()]);
}
?>