document.addEventListener('DOMContentLoaded', () => {

    const ajaxPost = async (url, data) => {
        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            return await response.json();
        } catch (err) {
            console.error('AJAX error:', err);
            return { success: false, error: 'Ошибка соединения с сервером' };
        }
    };

    const showAlert = (msg, type = 'success', timeout = 4000) => {
        const container = document.querySelector('#alert-container');
        if (!container) return;
        const alert = document.createElement('div');
        alert.className = `alert alert-${type} fade-in`;
        alert.textContent = msg;
        container.appendChild(alert);
        setTimeout(() => alert.remove(), timeout);
    };

    document.querySelectorAll('.btn-add-to-cart').forEach(btn => {
        btn.addEventListener('click', async () => {
            const itemKey = btn.dataset.key;
            const res = await ajaxPost('/ajax/cart_add.php', { item_key: itemKey, csrf: window.CSRF_TOKEN });
            showAlert(res.success ? 'Товар добавлен в корзину' : res.error, res.success ? 'success' : 'danger');
        });
    });

    document.querySelectorAll('.btn-remove-from-cart').forEach(btn => {
        btn.addEventListener('click', async () => {
            const itemKey = btn.dataset.key;
            const res = await ajaxPost('/ajax/cart_remove.php', { item_key: itemKey, csrf: window.CSRF_TOKEN });
            showAlert(res.success ? 'Товар удалён из корзины' : res.error, res.success ? 'success' : 'danger');
            if (res.success) btn.closest('tr').remove();
        });
    });

    document.querySelectorAll('.cart-quantity').forEach(input => {
        input.addEventListener('change', async () => {
            const itemKey = input.dataset.key;
            let quantity = parseInt(input.value);
            if (isNaN(quantity) || quantity <= 0) quantity = 1;
            const res = await ajaxPost('/ajax/cart_update.php', { item_key: itemKey, quantity, csrf: window.CSRF_TOKEN });
            showAlert(res.success ? 'Корзина обновлена' : res.error, res.success ? 'success' : 'danger');
        });
    });

    const discountForm = document.querySelector('#discount-form');
    if (discountForm) {
        discountForm.addEventListener('submit', async (e) => {
            e.preventDefault();
            const code = discountForm.querySelector('input[name="discount"]').value.trim();
            if (!code) return showAlert('Введите код скидки', 'warning');
            const res = await ajaxPost('/ajax/apply_discount.php', { discount: code, csrf: window.CSRF_TOKEN });
            if (res.success) {
                showAlert(`Скидка ${res.discount_percent}% применена!`);
                const totalEl = document.querySelector('#cart-total');
                if (totalEl) totalEl.textContent = res.discounted_total.toFixed(2);
            } else {
                showAlert(res.error || 'Неверная скидка', 'danger');
            }
        });
    }

    const checkoutForm = document.querySelector('#checkout-form');
    if (checkoutForm) {
        checkoutForm.addEventListener('submit', async (e) => {
            e.preventDefault();
            const formData = {};
            checkoutForm.querySelectorAll('input, select').forEach(el => formData[el.name] = el.value);
            formData.csrf = window.CSRF_TOKEN;

            const res = await ajaxPost('/ajax/checkout.php', formData);
            if (res.success) {
                showAlert('Заказ успешно оформлен!');
                document.querySelector('#cart-items').innerHTML = '';
                const totalEl = document.querySelector('#cart-total');
                if (totalEl) totalEl.textContent = '0.00';
            } else {
                showAlert(res.error || 'Ошибка оформления заказа', 'danger');
            }
        });
    }

});