// =========================
// checkout.js – AJAX оформление заказа
// =========================

document.addEventListener('DOMContentLoaded', () => {

    // =========================
    // Универсальная AJAX функция
    // =========================
    const ajaxPost = async (url, data) => {
        try {
            const response = await fetch(url, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            return await response.json();
        } catch (err) {
            console.error('AJAX error:', err);
            return { success: false, error: 'Ошибка соединения с сервером' };
        }
    };

    // =========================
    // Уведомления
    // =========================
    const showAlert = (msg, type = 'success', timeout = 5000) => {
        const container = document.querySelector('#alert-container');
        if (!container) return;
        const alert = document.createElement('div');
        alert.className = `alert alert-${type} fade-in`;
        alert.textContent = msg;
        container.appendChild(alert);
        setTimeout(() => alert.remove(), timeout);
    };

    // =========================
    // Обработка формы checkout
    // =========================
    const checkoutForm = document.querySelector('#checkout-form');
    if (!checkoutForm) return;

    checkoutForm.addEventListener('submit', async (e) => {
        e.preventDefault();

        // Собираем данные формы
        const formData = {};
        checkoutForm.querySelectorAll('input, select, textarea').forEach(el => {
            formData[el.name] = el.value.trim();
        });
        formData.csrf = window.CSRF_TOKEN;

        // Блокируем кнопку на время запроса
        const submitBtn = checkoutForm.querySelector('button[type="submit"]');
        submitBtn.disabled = true;
        submitBtn.textContent = 'Оформление...';

        // Отправка AJAX
        const res = await ajaxPost('/ajax/checkout.php', formData);

        // Обработка результата
        if (res.success) {
            showAlert('Заказ успешно оформлен!');
            // Очистка корзины
            const cartItems = document.querySelector('#cart-items');
            if (cartItems) cartItems.innerHTML = '';
            const totalEl = document.querySelector('#cart-total');
            if (totalEl) totalEl.textContent = '0.00';
            // Очистка формы
            checkoutForm.reset();
        } else {
            showAlert(res.error || 'Ошибка оформления заказа', 'danger');
        }

        // Разблокировка кнопки
        submitBtn.disabled = false;
        submitBtn.textContent = 'Оформить заказ';
    });

});
