<?php

function random_token($length = 32) {
    return bin2hex(random_bytes($length));
}

function is_valid_email($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

function is_valid_phone($phone) {
    return preg_match('/^\+?\d{7,15}$/', $phone);
}

function format_date($datetime, $format = 'd.m.Y H:i') {
    $dt = new DateTime($datetime);
    return $dt->format($format);
}

function unique_filename($filename) {
    $ext = pathinfo($filename, PATHINFO_EXTENSION);
    $name = bin2hex(random_bytes(8));
    return $name . '.' . $ext;
}

function cart_total($cart) {
    $total = 0;
    foreach ($cart as $item) {
        $total += $item['price'] * $item['quantity'];
    }
    return $total;
}

function apply_discount($total, $discount_percent) {
    return $total * (1 - $discount_percent / 100);
}

function status_badge($status) {
    $classes = [
        'Новый' => 'badge bg-primary',
        'В обработке' => 'badge bg-warning',
        'Готов' => 'badge bg-info',
        'Доставлен' => 'badge bg-success',
        'Отменен' => 'badge bg-danger'
    ];
    $class = $classes[$status] ?? 'badge bg-secondary';
    return "<span class=\"$class\">" . htmlspecialchars($status, ENT_QUOTES) . "</span>";
}
?>