<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

define('BASE_DIR', '/var/www/adr260/data/www/adred.ru');

require_once('/var/www/adr260/data/www/adred.ru/inc/configbd.php');

$mysqli = new mysqli(BD_HOST, BD_USER, BD_PASS, BD_NAME);

if ($mysqli->connect_error) {
    die('Ошибка подключения к базе данных: ' . $mysqli->connect_error);
}

$mysqli->set_charset("utf8");
$xml_content = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
$xml_content .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";

$static_pages = [
    ['loc' => 'https://adred.ru', 'priority' => '1.0', 'changefreq' => 'daily'],
    ['loc' => 'https://adred.ru/advertise.php', 'priority' => '0.8', 'changefreq' => 'daily'],
    ['loc' => 'https://adred.ru/advertise.php?mode=banners', 'priority' => '0.8', 'changefreq' => 'daily'],
    ['loc' => 'https://adred.ru/news.php', 'priority' => '0.8', 'changefreq' => 'daily'],
    ['loc' => 'https://adred.ru/info.php?mode=faq', 'priority' => '0.8', 'changefreq' => 'monthly'],
    ['loc' => 'https://adred.ru/info.php?mode=rules', 'priority' => '0.8', 'changefreq' => 'monthly'],
    ['loc' => 'https://adred.ru/info.php?mode=about', 'priority' => '0.7', 'changefreq' => 'monthly'],
    ['loc' => 'https://adred.ru/info.php?mode=partners', 'priority' => '0.7', 'changefreq' => 'monthly'],
    ['loc' => 'https://adred.ru/contact.php', 'priority' => '0.8', 'changefreq' => 'monthly'],
    ['loc' => 'https://adred.ru/user.php?mode=register', 'priority' => '0.8', 'changefreq' => 'monthly'],
    ['loc' => 'https://adred.ru/user.php?mode=lost', 'priority' => '0.6', 'changefreq' => 'monthly'],
    ['loc' => 'https://adred.ru/user.php?mode=login', 'priority' => '0.6', 'changefreq' => 'monthly'],
];

foreach ($static_pages as $page) {
    $xml_content .= '  <url>' . "\n";
    $xml_content .= '    <loc>' . $page['loc'] . '</loc>' . "\n";
    $xml_content .= '    <priority>' . $page['priority'] . '</priority>' . "\n";
    $xml_content .= '    <changefreq>' . $page['changefreq'] . '</changefreq>' . "\n";
    $xml_content .= '  </url>' . "\n";
}

$query = $mysqli->query("SELECT id, time_add FROM `".PREFIX."_news` ORDER BY time_add DESC");

if ($query && $query->num_rows > 0) {
    while ($news = $query->fetch_assoc()) {
        $xml_content .= '  <url>' . "\n";
        $xml_content .= '    <loc>https://adred.ru/news.php?id=' . $news['id'] . '</loc>' . "\n";
        $xml_content .= '    <priority>0.7</priority>' . "\n";
        $xml_content .= '    <changefreq>monthly</changefreq>' . "\n";
        $xml_content .= '    <lastmod>' . date('c', strtotime($news['time_add'])) . '</lastmod>' . "\n";
        $xml_content .= '  </url>' . "\n";
    }
}

$xml_content .= '</urlset>';
$mysqli->close();

$file_path = '/var/www/adr260/data/www/adred.ru/sitemap.xml';
if (file_put_contents($file_path, $xml_content)) {
    echo "Sitemap успешно обновлен: " . date('Y-m-d H:i:s') . "\n";
    echo "Добавлено страниц: " . (count($static_pages) + $query->num_rows) . "\n";
} else {
    echo "Ошибка при сохранении sitemap.xml\n";
    echo "Путь: " . $file_path . "\n";
}
?>