// Глобальные переменные для управления выбором
let selectedSites = new Set();
let totalAmount = 0;

// Функция для проверки заполнения формы баннеров и активации кнопки
function checkBannerForm() {
    const url = document.getElementById('url').value;
    const file = document.getElementById('file').files[0];
    const img = document.getElementById('img');
    const searchButton = document.getElementById('search-button');
    
    // Проверяем, что заполнены ОБА поля: URL И файл
    const isUrlFilled = url && url.startsWith('http');
    const isFileSelected = file || (img && img.value);
    
    // Активируем кнопку только если заполнены ОБА поля
    if (isUrlFilled && isFileSelected) {
        searchButton.disabled = false;
        searchButton.style.opacity = '1';
        searchButton.style.cursor = 'pointer';
    } else {
        searchButton.disabled = true;
        searchButton.style.opacity = '0.6';
        searchButton.style.cursor = 'not-allowed';
    }
}

// Функция для проверки заполнения формы ссылок и активации кнопки
function checkLinksForm() {
    const url = document.getElementById('url').value;
    const text = document.getElementById('text').value;
    const searchButton = document.querySelector('button[type="submit"]');
    
    // Проверяем оба поля
    const isUrlFilled = url && url.startsWith('http');
    const isTextFilled = text && text.length >= 2;
    
    // Активируем кнопку только если заполнены ОБА поля
    if (isUrlFilled && isTextFilled) {
        searchButton.disabled = false;
        searchButton.style.opacity = '1';
        searchButton.style.cursor = 'pointer';
    } else {
        searchButton.disabled = true;
        searchButton.style.opacity = '0.6';
        searchButton.style.cursor = 'not-allowed';
    }
}

// Обработчик выбора файла (для баннеров)
function handleFileSelect(input) {
    const file = input.files[0];
    const uploadDisplay = document.getElementById('upload');
    
    if (file) {
        uploadDisplay.textContent = file.name;
        
        // Проверка размера баннера
        const selectedSize = document.getElementById('size').value;
        const [requiredWidth, requiredHeight] = selectedSize.split('x').map(Number);
        const img = new Image();
        
        img.onload = function() {
            const errorMessage = document.getElementById('error-message');
            if (img.width !== requiredWidth || img.height !== requiredHeight) {
                errorMessage.textContent = `Размер баннера (${img.width}x${img.height}) не соответствует выбранному (${selectedSize}). Загрузите файл правильного размера.`;
                errorMessage.style.display = 'block';
                input.value = '';
                // Блокируем кнопку при неверном размере
                document.getElementById('search-button').disabled = true;
            } else {
                errorMessage.style.display = 'none';
                // После успешной загрузки файла проверяем форму
                checkBannerForm();
            }
        };
        
        const reader = new FileReader();
        reader.onload = function(e) {
            img.src = e.target.result;
        };
        reader.readAsDataURL(file);
    } else {
        // Если файл не выбран, проверяем форму
        checkBannerForm();
    }
}

// Обработчик выбора сайтов
document.addEventListener('DOMContentLoaded', function() {
    // Определяем текущий режим (баннеры или ссылки)
    const isBannerMode = window.location.href.includes('mode=banners');
    
    // Инициализируем проверку формы в зависимости от режима
    if (isBannerMode) {
        // Настройка обработчиков для баннеров
        const urlInput = document.getElementById('url');
        const fileInput = document.getElementById('file');
        
        if (urlInput) {
            urlInput.addEventListener('input', checkBannerForm);
            urlInput.addEventListener('change', checkBannerForm);
        }
        if (fileInput) {
            fileInput.addEventListener('change', function() {
                handleFileSelect(this);
            });
        }
        
        // Первоначальная проверка формы баннеров
        setTimeout(checkBannerForm, 100);
        
    } else {
        // Настройка обработчиков для ссылок
        const urlInput = document.getElementById('url');
        const textInput = document.getElementById('text');
        
        if (urlInput) {
            urlInput.addEventListener('input', checkLinksForm);
            urlInput.addEventListener('change', checkLinksForm);
        }
        if (textInput) {
            textInput.addEventListener('input', checkLinksForm);
            textInput.addEventListener('change', checkLinksForm);
        }
        
        // Первоначальная проверка формы ссылок
        setTimeout(checkLinksForm, 100);
    }

    const sitesContainer = document.getElementById('sites-container');
    if (sitesContainer) {
        sitesContainer.addEventListener('change', function(e) {
            if (e.target.classList.contains('site-checkbox')) {
                const siteCard = e.target.closest('.site-card');
                const siteId = siteCard.dataset.siteId;
                const price = parseFloat(e.target.dataset.price);
                
                if (e.target.checked) {
                    selectedSites.add(siteId);
                    totalAmount += price;
                    siteCard.classList.add('selected');
                } else {
                    selectedSites.delete(siteId);
                    totalAmount -= price;
                    siteCard.classList.remove('selected');
                }
                
                updateSelectionPanel();
            }
        });
    }

    // Обработчик выделения цветом для ссылок
    const premiumCheckbox = document.getElementById('premium');
    if (premiumCheckbox) {
        premiumCheckbox.addEventListener('change', function() {
            const colorContainer = document.getElementById('colorContainer');
            colorContainer.style.display = this.checked ? 'block' : 'none';
        });
    }

    // Отслеживание длины текста ссылки
    const textInput = document.getElementById('text');
    const textLength = document.getElementById('textLength');
    if (textInput && textLength) {
        textInput.addEventListener('input', function() {
            textLength.textContent = this.value.length;
        });
        // Инициализация при загрузке
        textLength.textContent = textInput.value.length;
    }
});

// Обновление панели выбора
function updateSelectionPanel() {
    const panel = document.getElementById('selectionPanel');
    const details = document.getElementById('selectionDetails');
    const payButton = document.getElementById('payButton');
    const selectedIds = document.getElementById('selectedIds');
    
    if (selectedSites.size > 0) {
        const siteWord = getSiteWord(selectedSites.size);
        details.textContent = `Выбрано ${selectedSites.size} ${siteWord} на сумму ${totalAmount} руб.`;
        payButton.disabled = false;
        selectedIds.value = Array.from(selectedSites).join('_');
        panel.classList.add('active');
    } else {
        details.textContent = 'Выберите сайты для размещения';
        payButton.disabled = true;
        selectedIds.value = '';
        panel.classList.remove('active');
    }
}

// Склонение слов
function getSiteWord(count) {
    const lastDigit = count % 10;
    const lastTwoDigits = count % 100;
    
    if (lastTwoDigits >= 11 && lastTwoDigits <= 19) {
        return 'сайтов';
    }
    if (lastDigit === 1) {
        return 'сайт';
    }
    if (lastDigit >= 2 && lastDigit <= 4) {
        return 'сайта';
    }
    return 'сайтов';
}

// Очистка выбора
function clearSelection() {
    selectedSites.clear();
    totalAmount = 0;
    
    document.querySelectorAll('.site-checkbox').forEach(checkbox => {
        checkbox.checked = false;
    });
    
    document.querySelectorAll('.site-card').forEach(card => {
        card.classList.remove('selected');
    });
    
    updateSelectionPanel();
}

// Валидация формы для баннеров (при отправке)
function validateForm() {
    const url = document.getElementById('url').value;
    const file = document.getElementById('file').files[0];
    const img = document.getElementById('img');
    
    if (!url && !file && !(img && img.value)) {
        alert('Заполните поле "Адрес ссылки" или выберите файл баннера');
        return false;
    }
    
    if (url && !url.startsWith('http://') && !url.startsWith('https://')) {
        alert('Адрес ссылки должен начинаться с http:// или https://');
        return false;
    }
    
    return true;
}

// Валидация формы для ссылок (при отправке)
function validateLinksForm() {
    const url = document.getElementById('url').value;
    const text = document.getElementById('text').value;
    
    if (!url || !text) {
        alert('Заполните поля "Адрес ссылки" и "Текст ссылки"');
        return false;
    }
    
    if (!url.startsWith('http://') && !url.startsWith('https://')) {
        alert('Адрес ссылки должен начинаться с http:// или https://');
        return false;
    }
    
    if (text.length < 2) {
        alert('Текст ссылки должен содержать минимум 2 символа');
        return false;
    }
    
    return true;
}

// Скрытие результатов при изменении параметров
document.addEventListener('DOMContentLoaded', function() {
    const form = document.forms.form1;
    if (form) {
        const inputs = form.querySelectorAll('input, select, textarea');
        
        inputs.forEach(input => {
            input.addEventListener('change', function() {
                if (document.querySelector('.sites-grid')) {
                    document.querySelector('.sites-grid').style.opacity = '0.5';
                }
            });
        });
    }
});